/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateColAddIntervalYearMonthScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalYearMonth value;
    private int outputColumn;
    private Date scratchDate1;
    private Date outputDate;
    private DateTimeMath dtm = new DateTimeMath();

    public DateColAddIntervalYearMonthScalar(int colNum, long value, int outputColumn) {
        this.colNum = colNum;
        this.value = new HiveIntervalYearMonth((int)value);
        this.outputColumn = outputColumn;
        this.scratchDate1 = new Date(0L);
        this.outputDate = new Date(0L);
    }

    public DateColAddIntervalYearMonthScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector1.noNulls;
        outputColVector.isRepeating = inputColVector1.isRepeating;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector1.isRepeating) {
            this.scratchDate1.setTime(DateWritable.daysToMillis((int)((int)vector1[0])));
            this.dtm.add(this.scratchDate1, this.value, this.outputDate);
            outputVector[0] = DateWritable.dateToDays((Date)this.outputDate);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchDate1.setTime(DateWritable.daysToMillis((int)((int)vector1[i])));
                    this.dtm.add(this.scratchDate1, this.value, this.outputDate);
                    outputVector[i] = DateWritable.dateToDays((Date)this.outputDate);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchDate1.setTime(DateWritable.daysToMillis((int)((int)vector1[i])));
                    this.dtm.add(this.scratchDate1, this.value, this.outputDate);
                    outputVector[i] = DateWritable.dateToDays((Date)this.outputDate);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchDate1.setTime(DateWritable.daysToMillis((int)((int)vector1[i])));
                this.dtm.add(this.scratchDate1, this.value, this.outputDate);
                outputVector[i] = DateWritable.dateToDays((Date)this.outputDate);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchDate1.setTime(DateWritable.daysToMillis((int)((int)vector1[i])));
                this.dtm.add(this.scratchDate1, this.value, this.outputDate);
                outputVector[i] = DateWritable.dateToDays((Date)this.outputDate);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date"), VectorExpressionDescriptor.ArgumentType.getType("interval_year_month")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

