/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDoubleInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterDoubleColumnInList
extends VectorExpression
implements IDoubleInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private double[] inListValues;
    private transient CuckooSetDouble inSet;

    public FilterDoubleColumnInList() {
        this.inSet = null;
    }

    public FilterDoubleColumnInList(int colNum) {
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetDouble(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.inputCol];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        double[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.inSet.lookup(vector[0])) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.inSet.lookup(vector[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.inSet.lookup(vector[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.inSet.lookup(vector[0])) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.inSet.lookup(vector[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.inSet.lookup(vector[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    public double[] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(double[] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputCol + ", values " + Arrays.toString(this.inListValues);
    }
}

