/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;

public final class WidthBucket$
implements Serializable {
    public static final WidthBucket$ MODULE$ = new WidthBucket$();

    public Long computeBucketNumber(double value, double min, double max, long numBucket) {
        if (this.isNull(value, min, max, numBucket)) {
            return null;
        }
        return this.computeBucketNumberNotNull(value, min, max, numBucket);
    }

    public boolean isNull(double value, double min, double max, long numBucket) {
        return numBucket <= 0L || numBucket == Long.MAX_VALUE || Double.isNaN(value) || min == max || Double.isNaN(min) || Double.isInfinite(min) || Double.isNaN(max) || Double.isInfinite(max);
    }

    public Long computeBucketNumberNotNull(double value, double min, double max, long numBucket) {
        double lower = Math.min(min, max);
        double upper = Math.max(min, max);
        if (min < max) {
            if (value < lower) {
                return Predef$.MODULE$.long2Long(0L);
            }
            if (value >= upper) {
                return Predef$.MODULE$.long2Long(numBucket + 1L);
            }
            return Predef$.MODULE$.long2Long((long)((double)numBucket * (value - lower) / (upper - lower)) + 1L);
        }
        if (value > upper) {
            return Predef$.MODULE$.long2Long(0L);
        }
        if (value <= lower) {
            return Predef$.MODULE$.long2Long(numBucket + 1L);
        }
        return Predef$.MODULE$.long2Long((long)((double)numBucket * (upper - value) / (upper - lower)) + 1L);
    }

    public WidthBucket apply(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.value(), (Object)x$0.minValue(), (Object)x$0.maxValue(), (Object)x$0.numBucket()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WidthBucket$.class);
    }

    private WidthBucket$() {
    }
}

