/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.ThetaUnion$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(first, second, lgNomEntries) - Merges two binary representations of\n    Datasketches ThetaSketch objects using a ThetaSketch Union object. Users can set\n    lgNomEntries to a value between 4 and 26 to find the union of sketches with different\n    union buffer size values (defaults to 12). ", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(theta_sketch_agg(col1), theta_sketch_agg(col2))) FROM VALUES (1, 4), (1, 4), (2, 5), (2, 5), (3, 6) tab(col1, col2);\n       6\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011!A\u0006A!f\u0001\n\u0003\t\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000bi\u0003A\u0011A.\t\u000b\u0001\u0004A\u0011I1\t\u000bi\u0003A\u0011A3\t\u000bi\u0003A\u0011\u00015\t\u000b=\u0004A\u0011\u000b9\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\n\u0003s\u0001\u0011\u0011!C\u0001\u0003wA\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\t\u0013\u0005m\u0003!%A\u0005\u0002\u0005\u0015\u0003\"CA/\u0001E\u0005I\u0011AA#\u0011%\ty\u0006AA\u0001\n\u0003\n\t\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0001\u0002t!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007fB\u0011\"!$\u0001\u0003\u0003%\t!a$\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0005\"CAM\u0001\u0005\u0005I\u0011IAN\u000f%\tylIA\u0001\u0012\u0003\t\tM\u0002\u0005#G\u0005\u0005\t\u0012AAb\u0011\u0019QF\u0004\"\u0001\u0002\\\"I\u0011Q\u001c\u000f\u0002\u0002\u0013\u0015\u0013q\u001c\u0005\n\u0003Cd\u0012\u0011!CA\u0003GD\u0011\"a;\u001d\u0003\u0003%\t)!<\t\u0013\u0005}H$!A\u0005\n\t\u0005!A\u0003+iKR\fWK\\5p]*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001cUZd\b\u0012\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1\u0014(D\u00018\u0015\tA4%A\u0004d_\u0012,w-\u001a8\n\u0005i:$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005Ib\u0014BA\u001f$\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\b!J|G-^2u!\t)UJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011jL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!\u0001\u0014!\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0019\u0002\u000bQAZ5sgR,\u0012A\u0015\t\u0003eMK!\u0001V\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004gSJ\u001cH\u000fI\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000fM,7m\u001c8eA\u0005)A\u000f[5sI\u00061A\u000f[5sI\u0002\na\u0001P5oSRtD\u0003\u0002/^=~\u0003\"A\r\u0001\t\u000bA;\u0001\u0019\u0001*\t\u000bY;\u0001\u0019\u0001*\t\u000ba;\u0001\u0019\u0001*\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t!\r\u0005\u0002@G&\u0011A\r\u0011\u0002\b\u0005>|G.Z1o)\rafm\u001a\u0005\u0006!&\u0001\rA\u0015\u0005\u0006-&\u0001\rA\u0015\u000b\u00059&T7\u000eC\u0003Q\u0015\u0001\u0007!\u000bC\u0003W\u0015\u0001\u0007!\u000bC\u0003Y\u0015\u0001\u0007A\u000e\u0005\u0002@[&\u0011a\u000e\u0011\u0002\u0004\u0013:$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0011a\u0016o];\t\u000bI\\\u0001\u0019\u0001*\u0002\u00119,wOR5sgRDQ\u0001^\u0006A\u0002I\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\u000bY\\\u0001\u0019\u0001*\u0002\u00119,w\u000f\u00165je\u0012\f!\u0002\u001d:fiRLh*Y7f+\u0005I\bC\u0001>\u007f\u001d\tYH\u0010\u0005\u0002H\u0001&\u0011Q\u0010Q\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{\u0002\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\t9\u0001E\u0003F\u0003\u0013\ti!C\u0002\u0002\f=\u00131aU3r!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nO\u0005)A/\u001f9fg&!\u0011qCA\t\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\ti\u0002\u0005\u0003\u0002\u0010\u0005}\u0011\u0002BA\u0011\u0003#\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003O\ti#!\r\u00026A\u0019q(!\u000b\n\u0007\u0005-\u0002IA\u0002B]fDq!a\f\u0010\u0001\u0004\t9#\u0001\u0004wC2,X-\r\u0005\b\u0003gy\u0001\u0019AA\u0014\u0003\u00191\u0018\r\\;fe!9\u0011qG\bA\u0002\u0005\u001d\u0012A\u0002<bYV,7'\u0001\u0003d_BLHc\u0002/\u0002>\u0005}\u0012\u0011\t\u0005\b!B\u0001\n\u00111\u0001S\u0011\u001d1\u0006\u0003%AA\u0002ICq\u0001\u0017\t\u0011\u0002\u0003\u0007!+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d#f\u0001*\u0002J-\u0012\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003%)hn\u00195fG.,GMC\u0002\u0002V\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI&a\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!A.\u00198h\u0015\t\ti'\u0001\u0003kCZ\f\u0017bA@\u0002h\u0005a\u0001O]8ek\u000e$\u0018I]5usV\tA.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0012\u0011\u0010\u0005\t\u0003w2\u0012\u0011!a\u0001Y\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!!\u0011\r\u0005\r\u0015\u0011RA\u0014\u001b\t\t)IC\u0002\u0002\b\u0002\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY)!\"\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004E\u0006E\u0005\"CA>1\u0005\u0005\t\u0019AA\u0014\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u0014q\u0013\u0005\t\u0003wJ\u0012\u0011!a\u0001Y\u00061Q-];bYN$2AYAO\u0011%\tYHGA\u0001\u0002\u0004\t9\u0003K\n\u0001\u0003C\u000b9+!+\u0002.\u0006=\u00161WA[\u0003s\u000bY\fE\u00023\u0003GK1!!*$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a+\u0002\u0005;R\u0001\u0005\t\u0011!?\u001a+fjQ0)M&\u00148\u000f\u001e\u0017!g\u0016\u001cwN\u001c3-A1<gj\\7F]R\u0014\u0018.Z:*A5\u0002S*\u001a:hKN\u0004Co^8!E&t\u0017M]=!e\u0016\u0004(/Z:f]R\fG/[8og\u0002zgM\u0003\u0011!A\u0001\"\u0015\r^1tW\u0016$8\r[3tAQCW\r^1TW\u0016$8\r\u001b\u0011pE*,7\r^:!kNLgn\u001a\u0011bAQCW\r^1TW\u0016$8\r\u001b\u0011V]&|g\u000eI8cU\u0016\u001cGO\f\u0011Vg\u0016\u00148\u000fI2b]\u0002\u001aX\r\u001e\u0006!A\u0001\u0002Cn\u001a(p[\u0016sGO]5fg\u0002\"x\u000eI1!m\u0006dW/\u001a\u0011cKR<X-\u001a8!i\u0001\ng\u000e\u001a\u00113m\u0001\"x\u000e\t4j]\u0012\u0004C\u000f[3!k:LwN\u001c\u0011pM\u0002\u001a8.\u001a;dQ\u0016\u001c\be^5uQ\u0002\"\u0017N\u001a4fe\u0016tGO\u0003\u0011!A\u0001*h.[8oA\t,hMZ3sAML'0\u001a\u0011wC2,Xm\u001d\u0011)I\u00164\u0017-\u001e7ug\u0002\"x\u000eI\u00193S9\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0016!a\u001e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQDW\r^1`g.,Go\u00195`KN$\u0018.\\1uK\"zf)\u0016(D?\"\"\b.\u001a;b?N\\W\r^2i?\u0006<w\rK2pYFJC\u0006\t;iKR\fwl]6fi\u000eDw,Y4hQ\r|GNM\u0015*S\u00012%kT'!-\u0006cU+R*!QEb\u0003\u0005N\u0015-A!\nD\u0006\t\u001b*Y\u0001B#\u0007\f\u00116S1\u0002\u0003F\r\u0017!k%b\u0003\u0005K\u001a-AYJ\u0003\u0005^1cQ\r|G.\r\u0017!G>d''K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u00028\u0006QQ.[:d?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005u\u0016!\u0002\u001b/c9\u0002\u0014A\u0003+iKR\fWK\\5p]B\u0011!\u0007H\n\u00069\u0005\u0015\u0017\u0011\u001b\t\t\u0003\u000f\fiM\u0015*S96\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017\u0004\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u001f\fIMA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fY'\u0001\u0002j_&\u0019a*!6\u0015\u0005\u0005\u0005\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0014!B1qa2LHc\u0002/\u0002f\u0006\u001d\u0018\u0011\u001e\u0005\u0006!~\u0001\rA\u0015\u0005\u0006-~\u0001\rA\u0015\u0005\u00061~\u0001\rAU\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty/a?\u0011\u000b}\n\t0!>\n\u0007\u0005M\bI\u0001\u0004PaRLwN\u001c\t\u0007\u007f\u0005](K\u0015*\n\u0007\u0005e\bI\u0001\u0004UkBdWm\r\u0005\t\u0003{\u0004\u0013\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\u0001\u0003BA3\u0005\u000bIAAa\u0002\u0002h\t1qJ\u00196fGR\u0004")
public class ThetaUnion
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ThetaUnion x$0) {
        return ThetaUnion$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ThetaUnion> tupled() {
        return ThetaUnion$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ThetaUnion>>> curried() {
        return ThetaUnion$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public ThetaUnion withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "theta_union";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2, Object value3) {
        int logNominalEntries = BoxesRunTime.unboxToInt((Object)value3);
        ThetaSketchUtils$.MODULE$.checkLgNomLongs(logNominalEntries, this.prettyName());
        byte[] sketch1Bytes = (byte[])value1;
        CompactSketch sketch1 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch1Bytes, this.prettyName());
        byte[] sketch2Bytes = (byte[])value2;
        CompactSketch sketch2 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch2Bytes, this.prettyName());
        CompactSketch union = SetOperation.builder().setLogNominalEntries(logNominalEntries).buildUnion().union((Sketch)sketch1, (Sketch)sketch2);
        return union.toByteArrayCompressed();
    }

    public ThetaUnion copy(Expression first, Expression second, Expression third) {
        return new ThetaUnion(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "ThetaUnion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
            case 2: {
                return this.third();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaUnion;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaUnion)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaUnion thetaUnion = (ThetaUnion)x$1;
        Expression expression = this.first();
        Expression expression2 = thetaUnion.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = thetaUnion.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = thetaUnion.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!thetaUnion.canEqual(this)) return false;
        return true;
    }

    public ThetaUnion(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ThetaUnion(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)));
    }

    public ThetaUnion(Expression first, Expression second, int third) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)third)));
    }
}

