/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    This function returns -1 for null input only if spark.sql.ansi.enabled is false and\n    spark.sql.legacy.sizeOfNull is true. Otherwise, it returns null for null input.\n    With the default settings, the function returns null for null input.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n  ", since="1.5.0", group="collection_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\u0011\u0007\u0001\"\u0011O\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015Y\u0007\u0001\"\u0011O\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\ti\u0001\u0001C)\u0003\u001fA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"!\u001d\u0001\u0003\u0003%\t!a\u001d\t\u0013\u0005]\u0004!!A\u0005B\u0005e\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u000f\u001d\t\u0019\u000b\tE\u0001\u0003K3aa\b\u0011\t\u0002\u0005\u001d\u0006BB*\u001a\t\u0003\tI\fC\u0004\u0002<f!\t!!0\t\u0013\u0005m\u0016$!A\u0005\u0002\u0006\u0005\u0007\"CAd3\u0005\u0005I\u0011QAe\u0011%\tY.GA\u0001\n\u0013\tiN\u0001\u0003TSj,'BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q#'N\u001e\u0011\u0005=\u0002T\"\u0001\u0011\n\u0005E\u0002#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=\u001a\u0014B\u0001\u001b!\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\taDI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tL\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!aQ\u001c\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007^\nQa\u00195jY\u0012,\u0012!\u0013\t\u0003_)K!a\u0013\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0011Y\u0016<\u0017mY=TSj,wJ\u001a(vY2,\u0012a\u0014\t\u0003mAK!!U\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\tB.Z4bGf\u001c\u0016N_3PM:+H\u000e\u001c\u0011\u0002\rqJg.\u001b;?)\r)fk\u0016\t\u0003_\u0001AQaR\u0003A\u0002%CQ!T\u0003A\u0002=#\"!V-\t\u000b\u001d3\u0001\u0019A%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0012\nQ\u0001^=qKNL!!\u00190\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0007c\u0001\u001fgQ&\u0011qM\u0012\u0002\u0004'\u0016\f\bCA/j\u0013\tQgL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0003fm\u0006dGC\u00018r!\t1t.\u0003\u0002qo\t\u0019\u0011I\\=\t\u000fI\\\u0001\u0013!a\u0001g\u0006)\u0011N\u001c9viB\u0011A/^\u0007\u0002E%\u0011aO\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR!\u0011p`A\u0005!\tQX0D\u0001|\u0015\ta\b%A\u0004d_\u0012,w-\u001a8\n\u0005y\\(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0005A\u00021\u0001\u0002\u0004\u0005\u00191\r\u001e=\u0011\u0007i\f)!C\u0002\u0002\bm\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\f1\u0001\r!_\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA+\u0002\u0012!1\u00111C\u0007A\u0002%\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0003V\u00033\tY\u0002C\u0004H\u001dA\u0005\t\u0019A%\t\u000f5s\u0001\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0011U\rI\u00151E\u0016\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0005v]\u000eDWmY6fI*\u0019\u0011qF\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0005%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001dU\ry\u00151E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0006E\u00027\u0003+J1!a\u00168\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u0017Q\f\u0005\n\u0003?\u001a\u0012\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA3!\u0015\t9'!\u001co\u001b\t\tIGC\u0002\u0002l]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u001f\u0006U\u0004\u0002CA0+\u0005\u0005\t\u0019\u00018\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u007f\tY\bC\u0005\u0002`Y\t\t\u00111\u0001\u0002T\u00051Q-];bYN$2aTAA\u0011!\tyfFA\u0001\u0002\u0004q\u0007f\u0005\u0001\u0002\u0006\u0006-\u0015QRAI\u0003'\u000b9*!'\u0002\u001e\u0006}\u0005cA\u0018\u0002\b&\u0019\u0011\u0011\u0012\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qR\u0001\u0003f)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:ju\u0016\u0004sN\u001a\u0011b]\u0002\n'O]1zA=\u0014\b%\u0019\u0011nCBt#\u0002\t\u0011!AQC\u0017n\u001d\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002j\u0013\u0007\t4pe\u0002rW\u000f\u001c7!S:\u0004X\u000f\u001e\u0011p]2L\b%\u001b4!gB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002J7\u000f\t4bYN,\u0007%\u00198e\u0015\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]1,w-Y2z]ML'0Z(g\u001dVdG\u000eI5tAQ\u0014X/\u001a\u0018!\u001fRDWM]<jg\u0016d\u0003%\u001b;!e\u0016$XO\u001d8tA9,H\u000e\u001c\u0011g_J\u0004c.\u001e7mA%t\u0007/\u001e;/\u0015\u0001\u0002\u0003\u0005I,ji\"\u0004C\u000f[3!I\u00164\u0017-\u001e7uAM,G\u000f^5oONd\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bE\\;mY\u00022wN\u001d\u0011ok2d\u0007%\u001b8qkRt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!&\u0002\u0003\u0007Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDsEY\u0014-A\u001d\"w\u0005\f\u0011(G\u001eb\u0003eJ1(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u00037\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!)\u0002!\r|G\u000e\\3di&|gn\u00184v]\u000e\u001c\u0018\u0001B*ju\u0016\u0004\"aL\r\u0014\u000be\tI+a,\u0011\u0007Y\nY+C\u0002\u0002.^\u0012a!\u00118z%\u00164\u0007\u0003BAY\u0003ok!!a-\u000b\t\u0005U\u0016qI\u0001\u0003S>L1!RAZ)\t\t)+A\u0003baBd\u0017\u0010F\u0002V\u0003\u007fCQaR\u000eA\u0002%#R!VAb\u0003\u000bDQa\u0012\u000fA\u0002%CQ!\u0014\u000fA\u0002=\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002L\u0006]\u0007#\u0002\u001c\u0002N\u0006E\u0017bAAho\t1q\n\u001d;j_:\u0004RANAj\u0013>K1!!68\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\\\u000f\u0002\u0002\u0003\u0007Q+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a8\u0011\t\u0005\u0005\u0013\u0011]\u0005\u0005\u0003G\f\u0019E\u0001\u0004PE*,7\r\u001e")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size x$0) {
        return Size$.MODULE$.unapply(x$0);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        if (this.legacySizeOfNull()) {
            return false;
        }
        return super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            if (this.legacySizeOfNull()) {
                return BoxesRunTime.boxToInteger((int)-1);
            }
            return null;
        }
        DataType dataType = this.child().dataType();
        if (dataType instanceof ArrayType) {
            return BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
        }
        if (dataType instanceof MapType) {
            return BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedOperandTypeForSizeFunctionError(dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numElements()");
    }

    @Override
    public Size withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "legacySizeOfNull";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

