/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Second;
import org.apache.spark.sql.catalyst.expressions.Second$;
import org.apache.spark.sql.catalyst.expressions.SecondsOfTime;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimeType;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the second component of the given expression.\n\n    If `expr` is a TIMESTAMP or a string that can be cast to timestamp,\n    it returns the second of that timestamp.\n    If `expr` is a TIME type (since 4.1.0), it returns the second of the time-of-day.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2018-02-14 12:58:59');\n       59\n      > SELECT _FUNC_(TIME'13:25:59.999999');\n       59\n  ", since="1.5.0", group="datetime_funcs")
public final class SecondExpressionBuilder$
implements ExpressionBuilder {
    public static final SecondExpressionBuilder$ MODULE$ = new SecondExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String name, Seq<Expression> expressions) {
        if (expressions.isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(name, (Seq<Object>)new .colon.colon((Object)"> 0", (List)Nil$.MODULE$), expressions.length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Expression child = (Expression)expressions.head();
        DataType dataType = child.dataType();
        if (dataType instanceof TimeType) {
            return new SecondsOfTime(child);
        }
        return new Second(child, Second$.MODULE$.apply$default$2());
    }

    private SecondExpressionBuilder$() {
    }
}

