/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.\n      The function returns NULL if at least one of the input parameters is NULL.\n      When both of the input parameters are not NULL and day_of_week is an invalid input,\n      the function throws SparkIllegalArgumentException if `spark.sql.ansi.enabled` is set to true, otherwise NULL.\n      ", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tmb\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B.\t\u000b}\u0003A\u0011\u00011\t\u000b\u0015\u0004A\u0011\t.\t\u000b\u0019\u0004A\u0011\t*\t\u000b\u001d\u0004A\u0011\t*\t\u000b}\u0003A\u0011\u00015\t\u000b-\u0004A\u0011\t7\t\u000bY\u0004A\u0011I<\t\u000bm\u0004A\u0011\t.\t\u000bq\u0004A\u0011I?\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA \u0001\u0011E\u0013\u0011\t\u0005\b\u0003\u001f\u0002A\u0011IA\u0007\u0011\u001d\t\t\u0006\u0001C)\u0003'B\u0011\"!\u0018\u0001\u0003\u0003%\t!a\u0018\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005%\u0004\"CA@\u0001E\u0005I\u0011AA5\u0011%\t\t\tAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003G\u0003\u0011\u0011!C\u0001\u0003KC\u0011\"a+\u0001\u0003\u0003%\t%!,\t\u0013\u0005m\u0006!!A\u0005\u0002\u0005u\u0006\"CAa\u0001\u0005\u0005I\u0011IAb\u0011%\t9\rAA\u0001\n\u0003\nImB\u0005\u0002n*\n\t\u0011#\u0001\u0002p\u001aA\u0011FKA\u0001\u0012\u0003\t\t\u0010\u0003\u0004`C\u0011\u0005!\u0011\u0002\u0005\n\u0005\u0017\t\u0013\u0011!C#\u0005\u001bA\u0011Ba\u0004\"\u0003\u0003%\tI!\u0005\t\u0013\te\u0011%%A\u0005\u0002\u0005\r\u0005\"\u0003B\u000eC\u0005\u0005I\u0011\u0011B\u000f\u0011%\u0011y#II\u0001\n\u0003\t\u0019\tC\u0005\u00032\u0005\n\t\u0011\"\u0003\u00034\t9a*\u001a=u\t\u0006L(BA\u0016-\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055r\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001ADhP#\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tIT(\u0003\u0002?U\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0019seBA$M\u001d\tA5*D\u0001J\u0015\tQe'\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011Q*Q\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002N\u0003\u0006I1\u000f^1si\u0012\u000bG/Z\u000b\u0002'B\u0011\u0011\bV\u0005\u0003+*\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003)\u0019H/\u0019:u\t\u0006$X\rI\u0001\nI\u0006LxJZ,fK.\f!\u0002Z1z\u001f\u001a<V-Z6!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003m\u0003\"\u0001\u0011/\n\u0005u\u000b%a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u00147\r\u001a\t\u0003s\u0001AQ!U\u0004A\u0002MCQaV\u0004A\u0002MCq!W\u0004\u0011\u0002\u0003\u00071,\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e\u001e\u000b\u0004C&T\u0007\"\u00024\f\u0001\u0004\u0019\u0006\"B4\f\u0001\u0004\u0019\u0016AC5oaV$H+\u001f9fgV\tQ\u000eE\u0002G]BL!a\u001c)\u0003\u0007M+\u0017\u000f\u0005\u0002ri6\t!O\u0003\u0002t]\u0005)A/\u001f9fg&\u0011QO\u001d\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002qB\u0011\u0011/_\u0005\u0003uJ\u0014\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYR)a0a\u0001\u0002\bA\u0011\u0001i`\u0005\u0004\u0003\u0003\t%aA!os\"1\u0011QA\bA\u0002y\fQa\u001d;beRDa!!\u0003\u0010\u0001\u0004q\u0018A\u00023bs>3w+A\teCR,G+[7f+RLGn\u00117bgN,\"!a\u0004\u0011\t\u0005E\u0011\u0011\u0004\b\u0005\u0003'\t)\u0002\u0005\u0002I\u0003&\u0019\u0011qC!\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9\"Q\u0001\u000f]\u0016DH\u000fR1z\u000f\u0016t7i\u001c3f))\ty!a\t\u00024\u0005]\u00121\b\u0005\b\u0003K\t\u0002\u0019AA\u0014\u0003\t)g\u000f\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCK\u0001\bG>$WmZ3o\u0013\u0011\t\t$a\u000b\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u000e\u0012\u0001\u0004\ty!A\u0007eCf|emV3fWR+'/\u001c\u0005\b\u0003s\t\u0002\u0019AA\b\u0003\t\u0019H\rC\u0004\u0002>E\u0001\r!a\u0004\u0002\t\u0011|woU\u0001\nI><UM\\\"pI\u0016$b!a\n\u0002D\u00055\u0003bBA#%\u0001\u0007\u0011qI\u0001\u0004GRD\b\u0003BA\u0015\u0003\u0013JA!a\u0013\u0002,\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0013%\u0001\u0007\u0011qE\u0001\u000baJ,G\u000f^=OC6,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\t\u0017QKA-\u0011\u0019\t9\u0006\u0006a\u0001'\u00069a.Z<MK\u001a$\bBBA.)\u0001\u00071+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0005\f\t'a\u0019\u0002f!9\u0011+\u0006I\u0001\u0002\u0004\u0019\u0006bB,\u0016!\u0003\u0005\ra\u0015\u0005\b3V\u0001\n\u00111\u0001\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001b+\u0007M\u000big\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tI(Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0006*\u001a1,!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\t\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\t1\fgn\u001a\u0006\u0003\u0003+\u000bAA[1wC&!\u00111DAH\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\nE\u0002A\u0003?K1!!)B\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u0018q\u0015\u0005\n\u0003S[\u0012\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAX!\u0015\t\t,a.\u007f\u001b\t\t\u0019LC\u0002\u00026\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI,a-\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00047\u0006}\u0006\u0002CAU;\u0005\u0005\t\u0019\u0001@\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0017\u000b)\rC\u0005\u0002*z\t\t\u00111\u0001\u0002\u001e\u00061Q-];bYN$2aWAf\u0011!\tIkHA\u0001\u0002\u0004q\bf\u0005\u0001\u0002P\u0006U\u0017q[An\u0003;\f\t/a9\u0002h\u0006%\bcA\u001d\u0002R&\u0019\u00111\u001b\u0016\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011\\\u0001\u00040}3UKT\"`QM$\u0018M\u001d;`I\u0006$X\r\f\u0011eCf|vNZ0xK\u0016\\\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t4jeN$\b\u0005Z1uK\u0002:\b.[2iA%\u001c\b\u0005\\1uKJ\u0004C\u000f[1oA\u0001\u001cH/\u0019:u?\u0012\fG/\u001a1!C:$\u0007E\\1nK\u0012\u0004\u0013m\u001d\u0011j]\u0012L7-\u0019;fI:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rU\u000b\u0014'!S\u001a\u0004\u0013\r\u001e\u0011mK\u0006\u001cH\u000fI8oK\u0002zg\r\t;iK\u0002Jg\u000e];uAA\f'/Y7fi\u0016\u00148\u000fI5tA9+F\n\u0014\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007EY8uQ\u0002zg\r\t;iK\u0002Jg\u000e];uAA\f'/Y7fi\u0016\u00148\u000fI1sK\u0002rw\u000e\u001e\u0011O+2c\u0005%\u00198eA\u0011\f\u0017pX8g?^,Wm\u001b\u0011jg\u0002\ng\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,H\u000f\f\u0006!A\u0001\u0002\u0003\u0005\t;iK\u00022WO\\2uS>t\u0007\u0005\u001e5s_^\u001c\be\u00159be.LE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0011jM\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\"(/^3-A=$\b.\u001a:xSN,\u0007ET+M\u0019:R\u0001\u0005\t\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\faJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nT'\f\u00192[E\"t\u0005\f\u0011()V;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE*T\u0006M\u0019.eAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003K\fa\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002l\u0006)\u0011GL\u001b/a\u00059a*\u001a=u\t\u0006L\bCA\u001d\"'\u0015\t\u00131_A\u0000!!\t)0a?T'n\u000bWBAA|\u0015\r\tI0Q\u0001\beVtG/[7f\u0013\u0011\ti0a>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\u0011\u0011)!a%\u0002\u0005%|\u0017bA(\u0003\u0004Q\u0011\u0011q^\u0001\ti>\u001cFO]5oOR\u0011\u00111R\u0001\u0006CB\u0004H.\u001f\u000b\bC\nM!Q\u0003B\f\u0011\u0015\tF\u00051\u0001T\u0011\u00159F\u00051\u0001T\u0011\u001dIF\u0005%AA\u0002m\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yBa\u000b\u0011\u000b\u0001\u0013\tC!\n\n\u0007\t\r\u0012I\u0001\u0004PaRLwN\u001c\t\u0007\u0001\n\u001d2kU.\n\u0007\t%\u0012I\u0001\u0004UkBdWm\r\u0005\t\u0005[1\u0013\u0011!a\u0001C\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0004\u0005\u0003\u0002\u000e\n]\u0012\u0002\u0002B\u001d\u0003\u001f\u0013aa\u00142kK\u000e$\b")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$3() {
        return NextDay$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NextDay x$0) {
        return NextDay$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return NextDay$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NextDay>>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        try {
            int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        catch (SparkIllegalArgumentException e) {
            if (this.failOnError()) {
                throw e;
            }
            n = null;
        }
        return n;
    }

    private String dateTimeUtilClass() {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
    }

    private String nextDayGenCode(ExprCode ev, String dayOfWeekTerm, String sd, String dowS) {
        String failOnErrorBranch = this.failOnError() ? "throw e;" : ev.isNull() + " = true;";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n     |try {\n     |  int " + dayOfWeekTerm + " = " + this.dateTimeUtilClass() + ".getDayOfWeekFromString(" + dowS + ");\n     |  " + ev.value() + " = " + this.dateTimeUtilClass() + ".getNextDateForDayOfWeek(" + sd + ", " + dayOfWeekTerm + ");\n     |} catch (org.apache.spark.SparkIllegalArgumentException e) {\n     |  " + failOnErrorBranch + "\n     |}\n     |"));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(sd, dowS) -> {
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                Object object;
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null) {
                    return ev.isNull() + " = true;";
                }
                try {
                    int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                    object = ev.value() + " = " + this.dateTimeUtilClass() + ".getNextDateForDayOfWeek(" + sd + ", " + dayOfWeekValue + ");";
                }
                catch (SparkIllegalArgumentException sparkIllegalArgumentException) {
                    object = this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
                }
                return object;
            }
            return this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    @Override
    public NextDay withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        return new NextDay(startDate, dayOfWeek, failOnError);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.startDate();
            }
            case 1: {
                return this.dayOfWeek();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "startDate";
            }
            case 1: {
                return "dayOfWeek";
            }
            case 2: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        if (this.failOnError() != nextDay.failOnError()) return false;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public NextDay(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

