/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.DateSub;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import scala.runtime.BoxesRunTime;

public final class StringLiteralTypeCoercion$ {
    public static final StringLiteralTypeCoercion$ MODULE$ = new StringLiteralTypeCoercion$();

    public Expression apply(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof DateAdd) {
            DateAdd dateAdd = (DateAdd)expression2;
            Expression l = dateAdd.startDate();
            Expression r = dateAdd.days();
            if (r.dataType() instanceof StringType && r.foldable()) {
                int n;
                try {
                    Cast qual$1 = Cast$.MODULE$.apply(r, (DataType)IntegerType$.MODULE$, true);
                    InternalRow x$1 = qual$1.eval$default$1();
                    n = BoxesRunTime.unboxToInt((Object)qual$1.eval(x$1));
                }
                catch (NumberFormatException e) {
                    throw QueryCompilationErrors$.MODULE$.secondArgumentOfFunctionIsNotIntegerError("date_add", e);
                }
                int days = n;
                return new DateAdd(l, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)days)));
            }
        }
        if (expression2 instanceof DateSub) {
            DateSub dateSub = (DateSub)expression2;
            Expression l = dateSub.startDate();
            Expression r = dateSub.days();
            if (r.dataType() instanceof StringType && r.foldable()) {
                int n;
                try {
                    Cast qual$2 = Cast$.MODULE$.apply(r, (DataType)IntegerType$.MODULE$, true);
                    InternalRow x$2 = qual$2.eval$default$1();
                    n = BoxesRunTime.unboxToInt((Object)qual$2.eval(x$2));
                }
                catch (NumberFormatException e) {
                    throw QueryCompilationErrors$.MODULE$.secondArgumentOfFunctionIsNotIntegerError("date_sub", e);
                }
                int days = n;
                return new DateSub(l, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)days)));
            }
        }
        return expression2;
    }

    private StringLiteralTypeCoercion$() {
    }
}

