/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadataSource;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.maven.JSONFeatures;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="update-feature-versions", threadSafe=true)
public class UpdateVersionsMojo
extends AbstractIncludingFeatureMojo {
    private static final int INFO_PAD_SIZE = 95;
    @Parameter(property="includes")
    private String updatesIncludesList;
    @Parameter(property="excludes")
    private String updatesExcludesList;
    @Parameter(property="versionScope")
    private String versionScope;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;
    @Parameter(property="classifiers")
    private String classifiers;
    @Component(role=org.apache.maven.artifact.metadata.ArtifactMetadataSource.class)
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteArtifactRepositories;
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(-((\\d{8}\\.\\d{6})-(\\d+))|(SNAPSHOT))$");

    private List<String[]> parseMatches(String value, String matchType) throws MojoExecutionException {
        ArrayList<String[]> matches = null;
        if (value != null) {
            matches = new ArrayList<String[]>();
            for (String t : value.split(",")) {
                String[] val = t.split(":");
                if (val.length > 5) {
                    throw new MojoExecutionException("Illegal " + matchType + " " + String.valueOf(val));
                }
                matches.add(val);
            }
        }
        return matches;
    }

    private Map<String, Feature> getFeatures() throws MojoExecutionException {
        String[] selection = this.classifiers == null ? null : this.classifiers.split(",");
        LinkedHashMap<String, Feature> features = new LinkedHashMap<String, Feature>();
        for (Map.Entry<String, Feature> entry : this.selectAllFeatureFiles().entrySet()) {
            boolean selected = true;
            if (selection != null) {
                selected = false;
                String classifier = entry.getValue().getId().getClassifier();
                for (String c : selection) {
                    if (classifier == null) {
                        if (!":".equals(c)) continue;
                        selected = true;
                        break;
                    }
                    if (!classifier.trim().equals(c)) continue;
                    selected = true;
                    break;
                }
            }
            if (!selected) continue;
            features.put(entry.getKey(), ProjectHelper.getFeatures(this.project).get(entry.getKey()));
        }
        if (features.isEmpty()) {
            throw new MojoExecutionException("No features found in project!");
        }
        return features;
    }

    private void addDependencies(Set<ArtifactHolder> dependencies, List<Artifact> artifacts, UpdateConfig cfg) {
        for (Artifact a : artifacts) {
            String include = this.shouldHandle(a.getId(), cfg);
            if (include == null) continue;
            String newVersion = null;
            Scope scope = cfg.defaultScope;
            if (!include.trim().isEmpty() && (scope = UpdateVersionsMojo.getScope(include)) == null) {
                newVersion = include;
            }
            dependencies.add(this.createArtifactHolder(a, scope, newVersion));
        }
    }

    private Set<ArtifactHolder> getDependencies(Map<String, Feature> features, UpdateConfig cfg) {
        TreeSet<ArtifactHolder> dependencies = new TreeSet<ArtifactHolder>();
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            this.addDependencies(dependencies, (List<Artifact>)entry.getValue().getBundles(), cfg);
            for (Extension ext : entry.getValue().getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                this.addDependencies(dependencies, (List<Artifact>)ext.getArtifacts(), cfg);
            }
        }
        return dependencies;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Feature readRawFeature(String fileName) throws MojoExecutionException {
        try (FileReader r = new FileReader(new File(fileName));){
            Feature feature;
            String json = JSONFeatures.read(r, JSONFeatures.PLACEHOLDER_ID, fileName);
            try (StringReader featureReader = new StringReader(json);){
                feature = FeatureJSONReader.read((Reader)featureReader, (String)fileName);
            }
            return feature;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read feature file " + fileName, (Exception)e);
        }
    }

    private UpdateConfig createConfiguration() throws MojoExecutionException {
        UpdateConfig cfg = new UpdateConfig();
        cfg.includes = this.parseMatches(this.updatesIncludesList, "includes");
        if (cfg.includes != null) {
            cfg.includeVersionInfo = new ArrayList<String>();
            for (String[] include : cfg.includes) {
                int lastIndex;
                int pos = include[lastIndex = include.length - 1].indexOf(47);
                if (pos != -1) {
                    cfg.includeVersionInfo.add(include[lastIndex].substring(pos + 1));
                    include[lastIndex] = include[lastIndex].substring(0, pos);
                    continue;
                }
                cfg.includeVersionInfo.add("");
            }
        }
        cfg.excludes = this.parseMatches(this.updatesExcludesList, "excludes");
        cfg.defaultScope = UpdateVersionsMojo.getScope(this.versionScope);
        if (cfg.defaultScope == null) {
            throw new MojoExecutionException("Invalid update scope specified: " + this.versionScope);
        }
        return cfg;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        Map<String, Feature> features = this.getFeatures();
        UpdateConfig cfg = this.createConfiguration();
        cfg.updateInfos = this.getDependencies(features, cfg);
        this.lookupVersionUpdates(cfg.updateInfos);
        LinkedHashMap<String, UpdateResult> results = new LinkedHashMap<String, UpdateResult>();
        HashMap<String, Set<String>> globalPropertyUpdates = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            this.getLog().debug((CharSequence)("Checking feature file " + entry.getKey()));
            UpdateResult result = new UpdateResult();
            results.put(entry.getKey(), result);
            result.updates = this.getUpdates(entry.getValue(), cfg);
            if (result.updates.isEmpty()) continue;
            Feature rawFeature = this.readRawFeature(entry.getKey());
            if (!this.updateVersions(entry.getKey(), rawFeature, result, globalPropertyUpdates) || this.dryRun) continue;
            try (FileWriter fileWriter = new FileWriter(new File(entry.getKey()));){
                JSONFeatures.write(fileWriter, rawFeature);
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Unable to write feature file " + String.valueOf(entry.getValue()), (Exception)iOException);
            }
        }
        boolean printedHeader = false;
        for (Map.Entry entry : results.entrySet()) {
            if (!((UpdateResult)entry.getValue()).updates.isEmpty()) continue;
            if (!printedHeader) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"The following features have no updates:");
                printedHeader = true;
            }
            this.getLog().info((CharSequence)("- " + (String)entry.getKey()));
        }
        printedHeader = false;
        for (Map.Entry entry : results.entrySet()) {
            Object right;
            String left;
            if (((UpdateResult)entry.getValue()).updates.isEmpty()) continue;
            if (!printedHeader) {
                this.getLog().info((CharSequence)"");
                if (this.dryRun) {
                    this.getLog().info((CharSequence)"The following features could be updated:");
                } else {
                    this.getLog().info((CharSequence)"The following features are updated:");
                }
                printedHeader = true;
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Feature " + (String)entry.getKey()));
            for (ArtifactUpdate artifactUpdate : ((UpdateResult)entry.getValue()).updates) {
                left = "  " + artifactUpdate.artifact.getId().toMvnId() + "...";
                right = " -> " + artifactUpdate.newVersion;
                if (((String)right).length() + left.length() > 95) {
                    this.getLog().info((CharSequence)left);
                    this.getLog().info((CharSequence)StringUtils.leftPad((String)right, (int)95));
                    continue;
                }
                this.getLog().info((CharSequence)(StringUtils.rightPad((String)left, (int)(95 - ((String)right).length()), (String)".") + (String)right));
            }
            if (((UpdateResult)entry.getValue()).propertyUpdates.isEmpty()) continue;
            this.getLog().info((CharSequence)"  The following properties in the pom should be updated:");
            for (Map.Entry entry2 : ((UpdateResult)entry.getValue()).propertyUpdates.entrySet()) {
                left = "    Property '" + (String)entry2.getKey() + "' to ...";
                right = (String)entry2.getValue();
                if (((String)right).length() + left.length() > 95) {
                    this.getLog().info((CharSequence)left);
                    this.getLog().info((CharSequence)StringUtils.leftPad((String)right, (int)95));
                    continue;
                }
                this.getLog().info((CharSequence)(StringUtils.rightPad((String)left, (int)(95 - ((String)right).length()), (String)".") + (String)right));
            }
        }
        if (!globalPropertyUpdates.isEmpty()) {
            this.getLog().info((CharSequence)"Update summary for properties in the pom:");
            for (Map.Entry entry : globalPropertyUpdates.entrySet()) {
                if (((Set)entry.getValue()).size() > 1) {
                    throw new MojoExecutionException("Inconsistent use of version property " + (String)entry.getKey() + ". Different version updates available: " + String.valueOf(entry.getValue()));
                }
                String value = (String)((Set)entry.getValue()).iterator().next();
                Object object = this.project.getProperties().get(entry.getKey());
                if (object == null) {
                    throw new MojoExecutionException("Property '" + (String)entry.getKey() + "' is not defined in POM");
                }
                this.getLog().info((CharSequence)("  Please update property '" + (String)entry.getKey() + "' from " + String.valueOf(object) + " to " + value));
            }
        }
    }

    private String shouldHandle(ArtifactId id, UpdateConfig cfg) {
        String include = "";
        if (cfg.includes != null) {
            include = this.match(id, cfg.includes, cfg.includeVersionInfo);
        }
        if (include != null && cfg.excludes != null && this.match(id, cfg.excludes, null) != null) {
            include = null;
        }
        return include;
    }

    private boolean match(String value, String matcher) {
        if (matcher.endsWith("*")) {
            return value.startsWith(matcher.substring(0, matcher.length() - 1));
        }
        return matcher.equals(value);
    }

    private String match(ArtifactId id, List<String[]> matches, List<String> versionInfo) {
        boolean match = false;
        int index = 0;
        for (String[] m : matches) {
            match = this.match(id.getGroupId(), m[0]);
            if (match && m.length > 1) {
                match = this.match(id.getArtifactId(), m[1]);
            }
            if (match && m.length == 3) {
                match = this.match(id.getVersion(), m[2]);
            } else if (match && m.length == 4) {
                match = this.match(id.getVersion(), m[3]);
                if (match) {
                    match = this.match(id.getType(), m[2]);
                }
            } else if (match && m.length == 5 && (match = this.match(id.getVersion(), m[4])) && (match = this.match(id.getType(), m[2]))) {
                match = this.match(id.getClassifier(), m[3]);
            }
            if (match) break;
            ++index;
        }
        if (match) {
            if (versionInfo != null) {
                return versionInfo.get(index);
            }
            return "";
        }
        return null;
    }

    private String update(Artifact artifact, Set<ArtifactHolder> updates) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Searching for updates of " + artifact.getId().toMvnId()));
        String found = null;
        for (ArtifactHolder entry : updates) {
            if (!artifact.getId().equals((Object)entry.getArtifact().getId())) continue;
            found = entry.getUpdate();
            break;
        }
        String updated = null;
        if (found != null) {
            this.getLog().debug((CharSequence)("Updating " + artifact.getId().toMvnId() + " to " + found));
            updated = found;
        } else {
            this.getLog().debug((CharSequence)("No newer version found for " + artifact.getId().toMvnId()));
        }
        return updated;
    }

    private boolean updateVersions(String fileName, Feature rawFeature, UpdateResult result, Map<String, Set<String>> globalPropertyUpdates) throws MojoExecutionException {
        Iterator<ArtifactUpdate> iter = result.updates.iterator();
        while (iter.hasNext()) {
            Artifact oldArtifact;
            ArtifactUpdate update = iter.next();
            Object container = update.extension == null ? rawFeature.getBundles() : rawFeature.getExtensions().getByName(update.extension.getName()).getArtifacts();
            int pos = container.indexOf((Object)update.artifact);
            Artifact artifact = oldArtifact = pos == -1 ? null : (Artifact)container.get(pos);
            if (!container.removeExact(update.artifact.getId())) {
                boolean found;
                Artifact same = container.getSame(update.artifact.getId());
                boolean bl = found = same != null;
                if (same != null) {
                    if (!same.getId().getVersion().startsWith("${") || !same.getId().getVersion().endsWith("}")) {
                        found = false;
                    } else {
                        String propName = same.getId().getVersion().substring(2, same.getId().getVersion().length() - 1);
                        if (!update.artifact.getId().getVersion().equals(this.project.getProperties().get(propName))) {
                            found = false;
                        } else {
                            Set<String> versions = globalPropertyUpdates.get(propName);
                            if (versions == null) {
                                versions = new HashSet<String>();
                                globalPropertyUpdates.put(propName, versions);
                            }
                            versions.add(update.newVersion);
                            result.propertyUpdates.put(propName, update.newVersion);
                        }
                    }
                }
                if (!found) {
                    throw new MojoExecutionException("Unable to update artifact as it's not found in feature: " + update.artifact.getId().toMvnId());
                }
                iter.remove();
                continue;
            }
            Artifact newArtifact = new Artifact(update.artifact.getId().changeVersion(update.newVersion));
            newArtifact.getMetadata().putAll(oldArtifact.getMetadata());
            container.add(pos, (Object)newArtifact);
        }
        return !result.updates.isEmpty();
    }

    private void addUpdates(List<ArtifactUpdate> updates, Extension ext, Artifacts artifacts, UpdateConfig cfg) throws MojoExecutionException {
        for (Artifact a : artifacts) {
            String newVersion;
            if (this.shouldHandle(a.getId(), cfg) == null || (newVersion = this.update(a, cfg.updateInfos)) == null) continue;
            ArtifactUpdate update = new ArtifactUpdate();
            update.artifact = a;
            update.newVersion = newVersion;
            update.extension = ext;
            updates.add(update);
        }
    }

    private List<ArtifactUpdate> getUpdates(Feature feature, UpdateConfig cfg) throws MojoExecutionException {
        ArrayList<ArtifactUpdate> updates = new ArrayList<ArtifactUpdate>();
        this.addUpdates(updates, null, (Artifacts)feature.getBundles(), cfg);
        for (Extension ext : feature.getExtensions()) {
            if (ext.getType() != ExtensionType.ARTIFACTS) continue;
            this.addUpdates(updates, ext, ext.getArtifacts(), cfg);
        }
        return updates;
    }

    private ArtifactHolder createArtifactHolder(Artifact artifact, Scope scope, String newVersion) {
        return new ArtifactHolder(artifact, scope, newVersion);
    }

    private void lookupVersionUpdates(Set<ArtifactHolder> dependencies) throws MojoExecutionException {
        ArrayList<Callable<Void>> requestsForDetails = new ArrayList<Callable<Void>>(dependencies.size());
        for (ArtifactHolder dependency : dependencies) {
            requestsForDetails.add(() -> {
                ArtifactId id = dependency.getArtifact().getId();
                this.getLog().debug((CharSequence)("Checking " + id.getGroupId() + ":" + id.getArtifactId() + " for updates newer than " + id.getVersion()));
                ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(id.getType());
                DefaultArtifact artifact = new DefaultArtifact(id.getGroupId(), id.getArtifactId(), id.getVersion(), "provided", id.getType(), id.getClassifier(), handler);
                dependency.setVersions(this.artifactMetadataSource.retrieveAvailableVersions((org.apache.maven.artifact.Artifact)artifact, this.mavenSession.getLocalRepository(), this.remoteArtifactRepositories));
                return null;
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List responseForDetails = executor.invokeAll(requestsForDetails);
            for (Future details : responseForDetails) {
                details.get();
            }
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new MojoExecutionException("Unable to acquire metadata for dependencies " + String.valueOf(dependencies) + ": " + ie.getMessage(), ie);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static Scope getScope(String versionInfo) {
        Scope scope = versionInfo == null || "ANY".equalsIgnoreCase(versionInfo) ? Scope.ANY : ("MAJOR".equalsIgnoreCase(versionInfo) ? Scope.MAJOR : ("MINOR".equalsIgnoreCase(versionInfo) ? Scope.MINOR : ("INCREMENTAL".equalsIgnoreCase(versionInfo) ? Scope.INCREMENTAL : ("SUBINCREMENTAL".equalsIgnoreCase(versionInfo) ? Scope.SUBINCREMENTAL : null))));
        return scope;
    }

    private static final int getSegmentCount(ArtifactVersion v) {
        if (v == null) {
            return 0;
        }
        if (ArtifactUtils.isSnapshot((String)v.toString())) {
            return UpdateVersionsMojo.innerGetSegmentCount(UpdateVersionsMojo.stripSnapshot(v));
        }
        return UpdateVersionsMojo.innerGetSegmentCount(v);
    }

    private static ArtifactVersion incrementSegment(ArtifactVersion v, int segment) {
        if (ArtifactUtils.isSnapshot((String)v.toString())) {
            return UpdateVersionsMojo.copySnapshot(v, UpdateVersionsMojo.innerIncrementSegment(UpdateVersionsMojo.stripSnapshot(v), segment));
        }
        return UpdateVersionsMojo.innerIncrementSegment(v, segment);
    }

    private static int innerGetSegmentCount(ArtifactVersion v) {
        if (v.getBuildNumber() != 0) {
            return 4;
        }
        if ((v.getMajorVersion() != 0 || v.getMinorVersion() != 0 || v.getIncrementalVersion() != 0) && v.getQualifier() != null) {
            return 4;
        }
        String version = v.toString();
        if (version.indexOf(45) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 4;
        }
        if (version.indexOf(46) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 3;
        }
        if (StringUtils.isEmpty((String)version)) {
            return 3;
        }
        try {
            Integer.parseInt(version);
            return 3;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static ArtifactVersion innerIncrementSegment(ArtifactVersion v, int segment) {
        int segmentCount = UpdateVersionsMojo.innerGetSegmentCount(v);
        if (segment < 0 || segment >= segmentCount) {
            throw new IllegalArgumentException(v.toString());
        }
        String version = v.toString();
        if (segmentCount == 1) {
            version = UpdateVersionsMojo.alphaNumIncrement(version);
            return new DefaultArtifactVersion(version);
        }
        int major = v.getMajorVersion();
        int minor = v.getMinorVersion();
        int incremental = v.getIncrementalVersion();
        int build = v.getBuildNumber();
        String qualifier = v.getQualifier();
        int minorIndex = version.indexOf(46);
        boolean haveMinor = minorIndex != -1;
        int incrementalIndex = haveMinor ? version.indexOf(46, minorIndex + 1) : -1;
        boolean haveIncremental = incrementalIndex != -1;
        int buildIndex = version.indexOf(45);
        boolean haveBuild = buildIndex != -1 && qualifier == null;
        boolean haveQualifier = buildIndex != -1 && qualifier != null;
        switch (segment) {
            case 0: {
                ++major;
                minor = 0;
                incremental = 0;
                build = 0;
                qualifier = null;
                break;
            }
            case 1: {
                ++minor;
                incremental = 0;
                build = 0;
                if (!haveQualifier || !qualifier.endsWith("SNAPSHOT")) break;
                qualifier = "SNAPSHOT";
                break;
            }
            case 2: {
                ++incremental;
                build = 0;
                qualifier = null;
                break;
            }
            case 3: {
                if (haveQualifier) {
                    qualifier = UpdateVersionsMojo.qualifierIncrement(qualifier);
                    break;
                }
                ++build;
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(major);
        if (haveMinor || minor > 0 || incremental > 0) {
            result.append('.');
            result.append(minor);
        }
        if (haveIncremental || incremental > 0) {
            result.append('.');
            result.append(incremental);
        }
        if (haveQualifier && qualifier != null) {
            result.append('-');
            result.append(qualifier);
        } else if (haveBuild || build > 0) {
            result.append('-');
            result.append(build);
        }
        return new DefaultArtifactVersion(result.toString());
    }

    private static String qualifierIncrement(String qualifier) {
        if (qualifier.toLowerCase().startsWith("alpha")) {
            return qualifier.substring(0, 5) + UpdateVersionsMojo.alphaNumIncrement(qualifier.substring(5));
        }
        if (qualifier.toLowerCase().startsWith("beta")) {
            return qualifier.substring(0, 4) + UpdateVersionsMojo.alphaNumIncrement(qualifier.substring(4));
        }
        if (qualifier.toLowerCase().startsWith("milestone")) {
            return qualifier.substring(0, 8) + UpdateVersionsMojo.alphaNumIncrement(qualifier.substring(8));
        }
        if (qualifier.toLowerCase().startsWith("cr") || qualifier.toLowerCase().startsWith("rc") || qualifier.toLowerCase().startsWith("sp")) {
            return qualifier.substring(0, 2) + UpdateVersionsMojo.alphaNumIncrement(qualifier.substring(2));
        }
        return UpdateVersionsMojo.alphaNumIncrement(qualifier);
    }

    private static String alphaNumIncrement(String token) {
        int i = token.length();
        boolean done = false;
        Object newToken = token;
        while (!done && i > 0) {
            char c;
            if ('0' <= (c = token.charAt(--i)) && c < '9') {
                c = (char)(c + 1);
                newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c == '9') {
                c = '0';
                newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
                continue;
            }
            if ('A' <= c && c < 'Z') {
                c = (char)(c + 1);
                newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c == 'Z') {
                c = 'A';
                newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
                continue;
            }
            if ('a' <= c && c < 'z') {
                c = (char)(c + '\u0001');
                newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
                done = true;
                continue;
            }
            if (c != 122) continue;
            c = 'a';
            newToken = ((String)newToken).substring(0, i) + c + (i + 1 < ((String)newToken).length() ? ((String)newToken).substring(i + 1) : "");
        }
        if (done) {
            return newToken;
        }
        boolean lastNumeric = false;
        boolean lastAlpha = false;
        boolean lastUpper = false;
        i = token.length();
        while (!lastAlpha && !lastNumeric && i > 0) {
            char c = token.charAt(--i);
            lastAlpha = Character.isLetter(c);
            lastUpper = c == Character.toUpperCase(c);
            lastNumeric = Character.isDigit(c);
        }
        if (lastAlpha) {
            if (lastUpper) {
                return token + "A";
            }
            return token + "a";
        }
        return token + "0";
    }

    private static ArtifactVersion stripSnapshot(ArtifactVersion v) {
        String version = v.toString();
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version);
        if (matcher.find()) {
            return new DefaultArtifactVersion(version.substring(0, matcher.start(1) - 1));
        }
        return v;
    }

    private static ArtifactVersion copySnapshot(ArtifactVersion source, ArtifactVersion destination) {
        Pattern matchSnapshotRegex;
        Matcher matcher;
        if (ArtifactUtils.isSnapshot((String)destination.toString())) {
            destination = UpdateVersionsMojo.stripSnapshot(destination);
        }
        if ((matcher = (matchSnapshotRegex = SNAPSHOT_PATTERN).matcher(source.toString())).find()) {
            return new DefaultArtifactVersion(destination.toString() + "-" + matcher.group(0));
        }
        return new DefaultArtifactVersion(destination.toString() + "-SNAPSHOT");
    }

    public static final class UpdateConfig {
        public List<String[]> includes;
        public List<String[]> excludes;
        public List<String> includeVersionInfo;
        Set<ArtifactHolder> updateInfos;
        public Scope defaultScope;
    }

    public static enum Scope {
        ANY,
        MAJOR,
        MINOR,
        INCREMENTAL,
        SUBINCREMENTAL;

    }

    private static class ArtifactHolder
    implements Comparable<ArtifactHolder> {
        private final SortedSet<ArtifactVersion> versions = new TreeSet<ArtifactVersion>();
        private final ArtifactVersion currentVersion;
        private final Scope updateScope;
        private final Artifact artifact;
        private final String newVersion;

        public ArtifactHolder(Artifact artifact, Scope updateScope, String newVersion) {
            this.artifact = artifact;
            this.updateScope = updateScope;
            this.currentVersion = new DefaultArtifactVersion(artifact.getId().getVersion());
            this.newVersion = newVersion;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public void setVersions(List<ArtifactVersion> versions) {
            for (ArtifactVersion candidate : versions) {
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                this.versions.add(candidate);
            }
        }

        private final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeLower, boolean includeUpper) {
            ArtifactVersion latest = null;
            for (ArtifactVersion candidate : this.versions) {
                int upper;
                int lower = lowerBound == null ? -1 : lowerBound.compareTo((Object)candidate);
                int n = upper = upperBound == null ? 1 : upperBound.compareTo((Object)candidate);
                if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                if (latest == null) {
                    latest = candidate;
                    continue;
                }
                if (latest.compareTo((Object)candidate) >= 0) continue;
                latest = candidate;
            }
            return latest;
        }

        public final String getUpdate() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            ArtifactVersion v = null;
            switch (this.updateScope.ordinal()) {
                case 4: {
                    v = UpdateVersionsMojo.getSegmentCount(this.currentVersion) < 3 ? null : this.getNewestVersion(this.currentVersion, UpdateVersionsMojo.incrementSegment(this.currentVersion, 2), false, false);
                    break;
                }
                case 3: {
                    v = UpdateVersionsMojo.getSegmentCount(this.currentVersion) < 3 ? null : this.getNewestVersion(UpdateVersionsMojo.incrementSegment(this.currentVersion, 2), UpdateVersionsMojo.incrementSegment(this.currentVersion, 1), true, false);
                    break;
                }
                case 2: {
                    v = UpdateVersionsMojo.getSegmentCount(this.currentVersion) < 2 ? null : this.getNewestVersion(UpdateVersionsMojo.incrementSegment(this.currentVersion, 1), UpdateVersionsMojo.incrementSegment(this.currentVersion, 0), true, false);
                    break;
                }
                case 1: {
                    v = UpdateVersionsMojo.getSegmentCount(this.currentVersion) < 1 ? null : this.getNewestVersion(UpdateVersionsMojo.incrementSegment(this.currentVersion, 0), null, true, false);
                    break;
                }
                case 0: {
                    v = this.getNewestVersion(this.currentVersion, null, false, false);
                }
            }
            return v != null ? v.toString() : null;
        }

        @Override
        public int compareTo(ArtifactHolder o) {
            return this.artifact.compareTo(o.getArtifact());
        }
    }

    public static final class UpdateResult {
        public List<ArtifactUpdate> updates;
        public Map<String, String> propertyUpdates = new HashMap<String, String>();
    }

    public static final class ArtifactUpdate {
        public Extension extension;
        public Artifact artifact;
        public String newVersion;
    }
}

