/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DynamicReferenceFrame;
import org.apache.sis.referencing.internal.AnnotatedMatrix;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.ExtentSelector;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private static final BursaWolfParameters[] EMPTY_ARRAY = new BursaWolfParameters[0];
    private Ellipsoid ellipsoid;
    private PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(properties);
        Object[] array;
        this.ellipsoid = Objects.requireNonNull(ellipsoid);
        this.primeMeridian = Objects.requireNonNull(primeMeridian);
        Object value = properties.get(BURSA_WOLF_KEY);
        if (value != null && (array = value instanceof Object[] ? (Object[])value : new Object[]{value}).length != 0) {
            this.bursaWolf = new BursaWolfParameters[array.length];
            for (int i = 0; i < array.length; ++i) {
                BursaWolfParameters param = (BursaWolfParameters)array[i];
                ArgumentChecks.ensureNonNullElement((String)BURSA_WOLF_KEY, (int)i, (Object)param);
                param = param.clone();
                param.verify(primeMeridian);
                this.bursaWolf[i] = param;
            }
            return;
        }
        this.bursaWolf = null;
    }

    protected DefaultGeodeticDatum(GeodeticDatum datum) {
        super((Datum)datum);
        this.ellipsoid = datum.getEllipsoid();
        this.primeMeridian = datum.getPrimeMeridian();
        this.bursaWolf = datum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)datum).bursaWolf : null;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum object) {
        if (object == null || object instanceof DefaultGeodeticDatum) {
            return (DefaultGeodeticDatum)object;
        }
        if (object instanceof DynamicReferenceFrame) {
            return new Dynamic(object);
        }
        return new DefaultGeodeticDatum(object);
    }

    public Class<? extends GeodeticDatum> getInterface() {
        return GeodeticDatum.class;
    }

    @XmlElement(name="ellipsoid", required=true)
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @XmlElement(name="primeMeridian", required=true)
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf == null) {
            return EMPTY_ARRAY;
        }
        BursaWolfParameters[] copy = (BursaWolfParameters[])this.bursaWolf.clone();
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = copy[i].clone();
        }
        return copy;
    }

    /*
     * Unable to fully structure code
     */
    public Matrix getPositionVectorTransformation(GeodeticDatum targetDatum, Extent areaOfInterest) {
        ArgumentChecks.ensureNonNull((String)"targetDatum", (Object)targetDatum);
        selector = new ExtentSelector<BursaWolfParameters>(areaOfInterest);
        candidate = this.select(targetDatum, selector);
        if (candidate != null) {
            return this.createTransformation(candidate, areaOfInterest);
        }
        if (targetDatum instanceof DefaultGeodeticDatum) {
            candidate = ((DefaultGeodeticDatum)targetDatum).select(this, selector);
            if (candidate != null) {
                try {
                    return Matrices.inverse(this.createTransformation(candidate, areaOfInterest));
                }
                catch (NoninvertibleMatrixException e) {
                    Logging.unexpectedException((Logger)CoordinateOperations.LOGGER, DefaultGeodeticDatum.class, (String)"getPositionVectorTransformation", (Throwable)e);
                }
            }
            if (this.bursaWolf != null) {
                bbox = selector.getAreaOfInterest();
                timeOfInterest = selector.getTimeOfInterest();
                useAOI = true;
                while (true) {
                    for (BursaWolfParameters toPivot : this.bursaWolf) {
                        if (!selector.setExtentOfInterest(toPivot.getDomainOfValidity(), bbox, timeOfInterest) || (candidate = ((DefaultGeodeticDatum)targetDatum).select(toPivot.getTargetDatum(), selector)) == null) continue;
                        step1 = this.createTransformation(toPivot, areaOfInterest);
                        step2 = this.createTransformation(candidate, areaOfInterest);
                        try {
                            m = MatrixSIS.castOrCopy(step2).inverse().multiply(step1);
                            return AnnotatedMatrix.indirect(m, useAOI);
                        }
                        catch (NoninvertibleMatrixException e) {
                            Logging.unexpectedException((Logger)CoordinateOperations.LOGGER, DefaultGeodeticDatum.class, (String)"getPositionVectorTransformation", (Throwable)e);
                        }
                    }
                    useAOI = false;
                    v0 = bbox;
                    bbox = null;
                    if (v0 != null) ** continue;
                    v1 = timeOfInterest;
                    timeOfInterest = null;
                    if (v1 == null) break;
                }
            }
        }
        return null;
    }

    private BursaWolfParameters select(GeodeticDatum targetDatum, ExtentSelector<BursaWolfParameters> selector) {
        if (this.bursaWolf == null) {
            return null;
        }
        for (BursaWolfParameters candidate : this.bursaWolf) {
            if (!Utilities.deepEquals((Object)targetDatum, (Object)candidate.getTargetDatum(), (ComparisonMode)ComparisonMode.COMPATIBILITY)) continue;
            selector.evaluate(candidate.getDomainOfValidity(), candidate);
        }
        return selector.best();
    }

    private Matrix createTransformation(BursaWolfParameters bursaWolf, Extent areaOfInterest) {
        Temporal epoch = null;
        if (bursaWolf.getClass() != BursaWolfParameters.class && (epoch = this.getFrameReferenceEpoch()) == null) {
            epoch = Extents.getInstant((Extent)areaOfInterest, null, (double)0.5).orElse(null);
        }
        return bursaWolf.getPositionVectorTransformation(epoch);
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        final String meridian = this.primeMeridian.getName().getCode();
        return NameToIdentifier.isHeuristicMatchForName((Identifier)super.getName(), super.getAlias(), (CharSequence)name, (NameToIdentifier.Simplifier)new AbstractDatum.Simplifier(this){
            final /* synthetic */ DefaultGeodeticDatum this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected CharSequence apply(CharSequence name) {
                int upper;
                int lower = CharSequences.indexOf((CharSequence)(name = super.apply(name)), (CharSequence)meridian, (int)0, (int)name.length()) - 1;
                if (lower >= 0 && name.charAt(lower) == '(' && (upper = lower + meridian.length() + 1) < name.length() && name.charAt(upper) == ')') {
                    int c;
                    for (lower = CharSequences.skipTrailingWhitespaces((CharSequence)name, (int)0, (int)lower); lower > 0; lower -= Character.charCount(c)) {
                        c = Character.codePointBefore(name, lower);
                        if (!Character.isLetterOrDigit(c)) continue;
                        name = new StringBuilder(name).delete(lower, upper + 1).toString();
                        break;
                    }
                }
                return name;
            }
        });
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultGeodeticDatum that = (DefaultGeodeticDatum)object;
                return Objects.equals(this.ellipsoid, that.ellipsoid) && Objects.equals(this.primeMeridian, that.primeMeridian) && Arrays.equals(this.bursaWolf, that.bursaWolf);
            }
        }
        GeodeticDatum that = (GeodeticDatum)object;
        return Utilities.deepEquals((Object)this.getEllipsoid(), (Object)that.getEllipsoid(), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.getPrimeMeridian(), (Object)that.getPrimeMeridian(), (ComparisonMode)mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.ellipsoid) + (long)(31 * Objects.hashCode(this.primeMeridian));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1;
        String name = super.formatTo(formatter);
        if (name != null) {
            return name;
        }
        formatter.newLine();
        formatter.appendFormattable(this.getEllipsoid(), DefaultEllipsoid::castOrCopy);
        boolean bl = isWKT1 = formatter.getConvention().majorVersion() == 1;
        if (isWKT1 && this.bursaWolf != null) {
            for (BursaWolfParameters candidate : this.bursaWolf) {
                if (!candidate.isToWGS84()) continue;
                formatter.newLine();
                formatter.append(candidate);
                break;
            }
        }
        formatter.newLine();
        if (!isWKT1 && !(formatter.getEnclosingElement(1) instanceof GeodeticCRS)) {
            return formatter.shortOrLong("Datum", "GeodeticDatum");
        }
        return "Datum";
    }

    private DefaultGeodeticDatum() {
        this.bursaWolf = null;
    }

    private void setEllipsoid(Ellipsoid value) {
        if (this.ellipsoid == null) {
            this.ellipsoid = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultGeodeticDatum.class, (String)"setEllipsoid", (String)"ellipsoid");
        }
    }

    private void setPrimeMeridian(PrimeMeridian value) {
        if (this.primeMeridian == null) {
            this.primeMeridian = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultGeodeticDatum.class, (String)"setPrimeMeridian", (String)"primeMeridian");
        }
    }

    public static class Dynamic
    extends DefaultGeodeticDatum
    implements DynamicReferenceFrame {
        private static final long serialVersionUID = 6117199873814779662L;
        private final Temporal frameReferenceEpoch;

        public Dynamic(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, Temporal epoch) {
            super(properties, ellipsoid, primeMeridian);
            this.frameReferenceEpoch = Objects.requireNonNull(epoch);
        }

        protected Dynamic(GeodeticDatum datum) {
            super(datum);
            this.frameReferenceEpoch = Objects.requireNonNull(((DynamicReferenceFrame)datum).getFrameReferenceEpoch());
        }

        @Override
        public Temporal getFrameReferenceEpoch() {
            return this.frameReferenceEpoch;
        }

        @Override
        public boolean equals(Object object, ComparisonMode mode) {
            return super.equals(object, mode) && (mode != ComparisonMode.STRICT || this.frameReferenceEpoch.equals(((Dynamic)object).frameReferenceEpoch));
        }

        @Override
        protected long computeHashCode() {
            return super.computeHashCode() + (long)(31 * this.frameReferenceEpoch.hashCode());
        }
    }
}

