/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.utils;

import io.protostuff.compiler.model.Proto;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.codec.protobuf.internal.converter.SwaggerToProtoGenerator;
import org.apache.servicecomb.codec.protobuf.schema.SchemaToProtoGenerator;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.ProtoMapperFactory;
import org.apache.servicecomb.swagger.SwaggerUtils;

public class ScopedProtobufSchemaManager {
    private final Map<String, ProtoMapper> mapperCache = new ConcurrentHashMapEx();
    private final Map<SchemaKey, ProtoMapper> schemaMapperCache = new ConcurrentHashMapEx();

    public ProtoMapper getOrCreateProtoMapper(SchemaMeta schemaMeta) {
        return this.mapperCache.computeIfAbsent(schemaMeta.getSchemaId(), key -> {
            OpenAPI swagger = schemaMeta.getSwagger();
            SwaggerToProtoGenerator generator = new SwaggerToProtoGenerator(schemaMeta.getMicroserviceQualifiedName(), swagger);
            Proto proto = generator.convert();
            ProtoMapperFactory protoMapperFactory = new ProtoMapperFactory();
            return protoMapperFactory.create(proto);
        });
    }

    public ProtoMapper getOrCreateProtoMapper(OpenAPI openAPI, String schemaId, String rootMessageName, Schema<?> schema) {
        SchemaKey schemaKey = new SchemaKey(schemaId, rootMessageName, schema);
        return this.schemaMapperCache.computeIfAbsent(schemaKey, key -> {
            SchemaToProtoGenerator generator = new SchemaToProtoGenerator("scb.schema", openAPI, key.schema, rootMessageName);
            Proto proto = generator.convert();
            ProtoMapperFactory protoMapperFactory = new ProtoMapperFactory();
            return protoMapperFactory.create(proto);
        });
    }

    static class SchemaKey {
        String schemaId;
        String rootMessage;
        Schema<?> schema;
        int hashCode = -1;

        SchemaKey(String schemaId, String rootMessage, Schema<?> schema) {
            this.schemaId = schemaId;
            this.rootMessage = rootMessage;
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaKey other = (SchemaKey)o;
            return StringUtils.equals((CharSequence)this.schemaId, (CharSequence)other.schemaId) && StringUtils.equals((CharSequence)this.rootMessage, (CharSequence)other.rootMessage) && SwaggerUtils.schemaEquals(this.schema, other.schema);
        }

        public int hashCode() {
            if (this.hashCode != -1) {
                return this.hashCode;
            }
            this.hashCode = this.schemaId.hashCode() ^ this.rootMessage.hashCode() ^ SwaggerUtils.schemaHashCode(this.schema);
            return this.hashCode;
        }
    }
}

