/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics.metric;

import java.util.concurrent.atomic.LongAdder;

public class DefaultEndpointMetric {
    private final String address;
    private final LongAdder connectCount = new LongAdder();
    private final LongAdder disconnectCount = new LongAdder();
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder requests = new LongAdder();
    private final LongAdder latency = new LongAdder();

    public DefaultEndpointMetric(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public long getConnectCount() {
        return this.connectCount.longValue();
    }

    public long getDisconnectCount() {
        return this.disconnectCount.longValue();
    }

    public long getCurrentConnectionCount() {
        return this.connectCount.longValue() - this.disconnectCount.longValue();
    }

    public void onConnect() {
        this.connectCount.increment();
    }

    public void onDisconnect() {
        this.disconnectCount.increment();
    }

    public long getBytesRead() {
        return this.bytesRead.longValue();
    }

    public void addBytesRead(long bytes) {
        this.bytesRead.add(bytes);
    }

    public long getBytesWritten() {
        return this.bytesWritten.longValue();
    }

    public void addBytesWritten(long bytes) {
        this.bytesWritten.add(bytes);
    }

    public void incrementRequests() {
        this.requests.increment();
    }

    public long getRequests() {
        return this.requests.longValue();
    }

    public void addLatency(long delta) {
        this.latency.add(delta);
    }

    public long getLatency() {
        return this.latency.longValue();
    }
}

