/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.swagger.generator.SwaggerConst;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;

public class OperationGeneratorContext
extends SwaggerGeneratorContext {
    private final Map<String, Schema<?>> responses = new HashMap();
    private JavaType responseType;
    private final Map<String, String> responseDescriptions = new HashMap<String, String>();
    private final Map<String, Map<String, Schema<?>>> responseHeaders = new HashMap();

    public OperationGeneratorContext(SwaggerGeneratorContext parent) {
        super(parent);
        this.updateResponse(SwaggerConst.SUCCESS_KEY, null);
    }

    public Map<String, Schema<?>> getResponses() {
        return this.responses;
    }

    public void updateResponse(String code, Schema<?> schema) {
        this.responses.put(code, schema);
    }

    public JavaType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(JavaType responseType) {
        this.responseType = responseType;
    }

    public Map<String, String> getResponseDescriptions() {
        return this.responseDescriptions;
    }

    public void updateResponseDescription(String code, String description) {
        this.responseDescriptions.put(code, description);
    }

    public Map<String, Map<String, Schema<?>>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void updateResponseHeader(String code, String header, Schema<?> schema) {
        this.responseHeaders.computeIfAbsent(code, key -> new HashMap());
        this.responseHeaders.get(code).put(header, schema);
    }

    public void updateProduces() {
        ArrayList<String> removed = new ArrayList<String>();
        for (String media : this.supportedProduces) {
            if (SUPPORTED_BODY_CONTENT_TYPE.contains(media)) continue;
            removed.add(media);
        }
        this.supportedProduces.removeAll(removed);
    }
}

