/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.ws;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.common.accessLog.AccessLogConfig;
import org.apache.servicecomb.common.accessLog.AccessLogInitializer;
import org.apache.servicecomb.common.accessLog.ws.WebSocketAccessLogConfig;
import org.apache.servicecomb.common.accessLog.ws.WebSocketAccessLogGenerator;
import org.apache.servicecomb.core.event.WebSocketActionEvent;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketAccessLogInitializer
implements AccessLogInitializer {
    private static final Logger ACCESS_LOG_LOGGER = LoggerFactory.getLogger((String)"ws.accesslog");
    private static final Logger REQUEST_LOG_LOGGER = LoggerFactory.getLogger((String)"ws.requestlog");
    private WebSocketAccessLogGenerator accessLogGenerator;
    private boolean clientLogEnabled;
    private boolean serverLogEnabled;

    @Override
    public void init(EventBus eventBus, AccessLogConfig accessLogConfig) {
        WebSocketAccessLogConfig config = WebSocketAccessLogConfig.INSTANCE;
        this.clientLogEnabled = config.isClientLogEnabled();
        this.serverLogEnabled = config.isServerLogEnabled();
        if (this.clientLogEnabled || this.serverLogEnabled) {
            this.accessLogGenerator = new WebSocketAccessLogGenerator();
            eventBus.register((Object)this);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRequestReceived(WebSocketActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        InvocationType invocationType = actionEvent.getInvocationType();
        if (invocationType == null) {
            return;
        }
        switch (invocationType) {
            case CONSUMER: {
                if (!this.clientLogEnabled) break;
                REQUEST_LOG_LOGGER.info(this.accessLogGenerator.generateClientLog(actionEvent));
                break;
            }
            case PRODUCER: {
                if (!this.serverLogEnabled) break;
                ACCESS_LOG_LOGGER.info(this.accessLogGenerator.generateServerLog(actionEvent));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected websocket invocation type: " + invocationType);
            }
        }
    }
}

