/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;
import org.apache.sedona.sql.datasources.osmpbf.model.OsmNode;

public class NodeIterator
implements Iterator<OSMEntity> {
    int idx = 0;
    long nodesCount = 0L;
    List<Osmformat.Node> nodes;
    Osmformat.StringTable stringTable;
    Osmformat.PrimitiveBlock primitiveBlock;

    public NodeIterator(List<Osmformat.Node> nodes, Osmformat.PrimitiveBlock primitiveBlock) {
        this.nodes = nodes;
        this.stringTable = primitiveBlock.getStringtable();
        this.primitiveBlock = primitiveBlock;
        if (nodes != null) {
            this.nodesCount = nodes.size();
        }
    }

    @Override
    public boolean hasNext() {
        return (long)this.idx < this.nodesCount;
    }

    @Override
    public OSMEntity next() {
        if ((long)this.idx < this.nodesCount) {
            OsmNode node = this.extract(this.idx);
            ++this.idx;
            return node;
        }
        return null;
    }

    public OsmNode extract(int idx) {
        return this.parse(idx);
    }

    private OsmNode parse(int idx) {
        Osmformat.Node node = this.nodes.get(idx);
        long id = node.getId();
        long latitude = node.getLat();
        long longitude = node.getLon();
        long latOffset = this.primitiveBlock.getLatOffset();
        long lonOffset = this.primitiveBlock.getLonOffset();
        long granularity = this.primitiveBlock.getGranularity();
        double lat = 1.0E-9 * (double)(latOffset + latitude * granularity);
        double lon = 1.0E-9 * (double)(lonOffset + longitude * granularity);
        HashMap<String, String> tags = TagsResolver.resolveTags(node.getKeysCount(), node::getKeys, node::getVals, this.stringTable);
        return new OsmNode(id, lat, lon, tags);
    }
}

