/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.twak.utils.Pair;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;

public class Loop<E>
implements Iterable<E> {
    public Loopable<E> start;
    public List<Loop<E>> holes = new ArrayList<Loop<E>>();

    public Loop() {
        this.start = null;
    }

    public Loop(List<E> toAdd) {
        for (E e : toAdd) {
            this.append(e);
        }
    }

    public Loop(E ... toAdd) {
        for (E e : toAdd) {
            this.append(e);
        }
    }

    public Loop(Loop<E> toClone) {
        for (E e : toClone) {
            this.append(e);
        }
    }

    public int count() {
        int count = 0;
        for (E e : this) {
            ++count;
        }
        return count;
    }

    public void removeAll() {
        this.start = null;
    }

    public Loopable<E> append(E ... append) {
        Loopable<E> last = null;
        for (E e : append) {
            last = this.append_(e);
        }
        return last;
    }

    public Loopable<E> append_(E append) {
        if (this.start == null) {
            this.start = new Loopable<E>(append);
            this.start.setNext(this.start);
            this.start.setPrev(this.start);
            return this.start;
        }
        Loopable<E> toAdd = new Loopable<E>(append);
        toAdd.setPrev(this.start.getPrev());
        toAdd.setNext(this.start);
        this.start.getPrev().setNext(toAdd);
        this.start.setPrev(toAdd);
        return toAdd;
    }

    public Loopable<E> prepend(E prepend) {
        this.start = this.append(prepend);
        return this.start;
    }

    public Loopable<E> addAfter(Loopable<E> loopable, E bar) {
        Loopable n = new Loopable(bar);
        if (loopable == null) {
            this.start = n;
            this.start.setNext(this.start);
            this.start.setPrev(this.start);
        } else {
            n.setPrev(loopable);
            n.setNext(loopable.next);
            n.getPrev().setNext(n);
            n.getNext().setPrev(n);
        }
        return n;
    }

    public void remove(E remove) {
        Loopable<E> togo = this.find(remove);
        this.remove(togo);
    }

    public void remove(Loopable<E> togo) {
        if (togo == this.start) {
            this.start = togo.prev == togo ? null : togo.prev;
        }
        togo.prev.next = togo.next;
        togo.next.prev = togo.prev;
    }

    public Loopable<E> find(E remove) {
        Loopable<E> n = this.start;
        while (n.next != this.start) {
            if (n.me.equals(remove)) {
                return n;
            }
            n = n.next;
        }
        if (n.me.equals(remove)) {
            return n;
        }
        return null;
    }

    public Loopable<E> getFirstLoopable() {
        return this.start;
    }

    public E getFirst() {
        if (this.start == null) {
            return null;
        }
        return this.start.me;
    }

    public Iterable<Loopable<E>> loopableIterator() {
        return new Iterable<Loopable<E>>(){

            @Override
            public Iterator<Loopable<E>> iterator() {
                return new LoopableIterator();
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return new LoopIterator();
    }

    public Loop<E> reverse() {
        if (this.start == null) {
            return this;
        }
        Loopable<E> m3 = this.start;
        do {
            Loopable tmp = m3.next;
            m3.next = m3.prev;
            m3.prev = tmp;
        } while ((m3 = m3.prev) != this.start);
        return this;
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<Loopable<E>> streamAble() {
        return StreamSupport.stream(this.loopableIterator().spliterator(), false);
    }

    public Iterable<Pair<E, E>> pairs() {
        return new Iterable<Pair<E, E>>(){

            @Override
            public Iterator<Pair<E, E>> iterator() {
                return new Iterator<Pair<E, E>>(){
                    LoopableIterator lit;
                    {
                        this.lit = new LoopableIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.lit.hasNext();
                    }

                    @Override
                    public Pair<E, E> next() {
                        Object l = this.lit.next();
                        return new Pair(((Loopable)l).get(), ((Loopable)l).getNext().get());
                    }
                };
            }
        };
    }

    public LoopL<E> singleton() {
        LoopL<Loop> out = new LoopL<Loop>();
        out.add(this);
        return out;
    }

    public abstract class Map<O> {
        public Loop<O> run() {
            Loop<Object> loopO = new Loop<Object>();
            for (Loopable e : Loop.this.loopableIterator()) {
                loopO.append(this.map(e));
            }
            return loopO;
        }

        public abstract O map(Loopable<E> var1);
    }

    public class LoopIterator
    implements Iterator<E> {
        LoopableIterator lit;

        public LoopIterator() {
            this.lit = new LoopableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.lit.hasNext();
        }

        @Override
        public E next() {
            return ((Loopable)this.lit.next()).me;
        }

        @Override
        public void remove() {
            this.lit.remove();
        }
    }

    public class LoopableIterator
    implements Iterator<Loopable<E>> {
        Loopable<E> s;
        Loopable<E> n;

        public LoopableIterator() {
            this.s = Loop.this.start;
            this.n = null;
        }

        @Override
        public boolean hasNext() {
            if (this.s == null) {
                return false;
            }
            if (this.n == null) {
                return true;
            }
            return this.n != Loop.this.start;
        }

        @Override
        public Loopable<E> next() {
            if (this.n == null) {
                this.n = Loop.this.start;
            }
            Loopable out = this.n;
            this.n = this.n.getNext();
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

