/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.geopackage.transform;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class DataTypesTransformations$ {
    public static final DataTypesTransformations$ MODULE$ = new DataTypesTransformations$();
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter[] datetimeFormatters = (DateTimeFormatter[])((Object[])new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SS"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.S"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")});

    private DateTimeFormatter dateFormatter() {
        return dateFormatter;
    }

    private DateTimeFormatter[] datetimeFormatters() {
        return datetimeFormatters;
    }

    public int getDays(String dateString) {
        LocalDate date = LocalDate.parse(dateString, this.dateFormatter());
        LocalDate epochDate = LocalDate.of(1970, 1, 1);
        return (int)ChronoUnit.DAYS.between(epochDate, date);
    }

    public long epoch(String timestampStr) {
        long l;
        Object object = new Object();
        try {
            try {
                l = Instant.parse(timestampStr).toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.datetimeFormatters()), (Function1 & Serializable)formatter -> {
                    DataTypesTransformations$.$anonfun$epoch$1(timestampStr, object, formatter);
                    return BoxedUnit.UNIT;
                });
                throw new IllegalArgumentException(new StringBuilder(119).append("Unable to parse datetime: ").append(timestampStr).append(". ").append("Expected formats: 'yyyy-MM-ddTHH:mm:ss[.SSS|.SS|.S]' or 'yyyy-MM-ddTHH:mm:ss[.SSS|.SS|.S]Z'").toString());
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                l = ex.value$mcJ$sp();
            }
            throw ex;
        }
        return l;
    }

    public static final /* synthetic */ void $anonfun$epoch$1(String timestampStr$1, Object nonLocalReturnKey1$1, DateTimeFormatter formatter) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timestampStr$1, formatter);
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        catch (DateTimeParseException dateTimeParseException) {
            return;
        }
    }

    private DataTypesTransformations$() {
    }
}

