/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.sedona.common.spider.Generator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ParcelGenerator
implements Generator {
    private final Random random;
    private long iRecord = 0L;
    private final long cardinality;
    private final double splitRange;
    private final double dither;
    private List<BoxWithLevel> boxesToSplit;
    private final int maxDepth;
    private final long numBoxesMaxDepth;

    public ParcelGenerator(Random random, ParcelParameter parameter) {
        this.random = random;
        this.cardinality = parameter.cardinality;
        this.splitRange = parameter.splitRange;
        this.dither = parameter.dither;
        this.boxesToSplit = new ArrayList<BoxWithLevel>();
        this.boxesToSplit.add(new BoxWithLevel(new Envelope(0.0, 1.0, 0.0, 1.0), 0));
        this.maxDepth = 64 - Long.numberOfLeadingZeros(this.cardinality - 1L);
        this.numBoxesMaxDepth = 2L * this.cardinality - (1L << this.maxDepth);
    }

    public Envelope generateBox() {
        assert (!this.boxesToSplit.isEmpty());
        assert (this.iRecord < this.cardinality);
        BoxWithLevel boxWithLevel = this.boxesToSplit.remove(this.boxesToSplit.size() - 1);
        int level = boxWithLevel.level;
        Envelope box = boxWithLevel.envelope;
        while (true) {
            if (level == this.maxDepth || level == this.maxDepth - 1 && this.iRecord >= this.numBoxesMaxDepth) {
                this.ditherBox(box);
                ++this.iRecord;
                return box;
            }
            Envelope[] splitBoxes = this.splitBox(box);
            this.boxesToSplit.add(new BoxWithLevel(splitBoxes[1], level + 1));
            ++level;
            box = splitBoxes[0];
        }
    }

    private Envelope[] splitBox(Envelope box) {
        boolean splitX;
        boolean bl = splitX = box.getWidth() > box.getHeight();
        if (splitX) {
            double splitPoint = box.getMinX() + box.getWidth() * (this.splitRange + this.random.nextDouble() * (1.0 - 2.0 * this.splitRange));
            return new Envelope[]{new Envelope(box.getMinX(), splitPoint, box.getMinY(), box.getMaxY()), new Envelope(splitPoint, box.getMaxX(), box.getMinY(), box.getMaxY())};
        }
        double splitPoint = box.getMinY() + box.getHeight() * (this.splitRange + this.random.nextDouble() * (1.0 - 2.0 * this.splitRange));
        return new Envelope[]{new Envelope(box.getMinX(), box.getMaxX(), box.getMinY(), splitPoint), new Envelope(box.getMinX(), box.getMaxX(), splitPoint, box.getMaxY())};
    }

    private void ditherBox(Envelope box) {
        double changeX = this.random.nextDouble() * this.dither * box.getWidth();
        double changeY = this.random.nextDouble() * this.dither * box.getHeight();
        box.init(box.getMinX() + changeX / 2.0, box.getMaxX() - changeX / 2.0, box.getMinY() + changeY / 2.0, box.getMaxY() - changeY / 2.0);
    }

    @Override
    public boolean hasNext() {
        return this.iRecord < this.cardinality;
    }

    @Override
    public Geometry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more parcels to generate");
        }
        return GEOMETRY_FACTORY.toGeometry(this.generateBox());
    }

    public static class ParcelParameter {
        public final long cardinality;
        public final double dither;
        public final double splitRange;

        public ParcelParameter(long cardinality, double dither, double splitRange) {
            if (cardinality < 0L) {
                throw new IllegalArgumentException("cardinality must be non-negative");
            }
            if (dither < 0.0 || dither > 1.0) {
                throw new IllegalArgumentException("dither must be in the range [0, 1]");
            }
            if (splitRange < 0.0 || splitRange > 0.5) {
                throw new IllegalArgumentException("splitRange must be in the range [0, 0.5]");
            }
            this.cardinality = cardinality;
            this.dither = dither;
            this.splitRange = splitRange;
        }

        public static ParcelParameter create(Map<String, String> conf) {
            long cardinality = Long.parseLong(conf.getOrDefault("cardinality", "100"));
            double dither = Double.parseDouble(conf.getOrDefault("dither", "0.5"));
            double splitRange = Double.parseDouble(conf.getOrDefault("splitRange", "0.5"));
            return new ParcelParameter(cardinality, dither, splitRange);
        }
    }

    private static class BoxWithLevel {
        public final Envelope envelope;
        public final int level;

        public BoxWithLevel(Envelope envelope, int level) {
            this.envelope = envelope;
            this.level = level;
        }
    }
}

