/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16hd;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.util.unsynced.LongArrayOps;
import ch.ethz.globis.phtree.v16hd.Node;
import ch.ethz.globis.phtree.v16hd.NodeIteratorNoGC;
import ch.ethz.globis.phtree.v16hd.PhTree16HD;
import java.util.NoSuchElementException;

public final class PhIteratorNoGC<T>
implements PhTree.PhQuery<T> {
    private final int dims;
    private final PhIteratorStack stack;
    private long[] rangeMin;
    private long[] rangeMax;
    private PhFilter checker;
    private final PhTree16HD<T> pht;
    private PhEntry<T> resultFree;
    private PhEntry<T> resultToReturn;
    private boolean isFinished = false;

    public PhIteratorNoGC(PhTree16HD<T> pht, PhFilter checker) {
        this.dims = pht.getDim();
        this.checker = checker;
        this.stack = new PhIteratorStack();
        this.pht = pht;
        this.resultFree = new PhEntry<Object>(new long[this.dims], null);
        this.resultToReturn = new PhEntry<Object>(new long[this.dims], null);
    }

    @Override
    public PhIteratorNoGC<T> reset(long[] rangeMin, long[] rangeMax) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.stack.size = 0;
        this.isFinished = false;
        if (this.pht.getRoot() == null) {
            this.isFinished = true;
            return this;
        }
        this.stack.prepareAndPush(this.pht.getRoot(), null);
        this.findNextElement();
        return this;
    }

    private void findNextElement() {
        PhEntry<T> result = this.resultFree;
        while (!this.stack.isEmpty()) {
            NodeIteratorNoGC<T> p = this.stack.peek();
            while (p.increment(result)) {
                if (result.hasNodeInternal()) {
                    p = this.stack.prepareAndPush((Node)result.getNodeInternal(), result.getKey());
                    continue;
                }
                this.resultFree = this.resultToReturn;
                this.resultToReturn = result;
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long[] nextKey() {
        long[] key = ((PhEntry)this.nextEntryReuse()).getKey();
        long[] ret = new long[key.length];
        LongArrayOps.arraycopy(key, 0, ret, 0, key.length);
        return ret;
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public PhEntry<T> nextEntry() {
        return new PhEntry(this.nextEntryReuse());
    }

    @Override
    public T next() {
        Object v = ((PhEntry)this.nextEntryReuse()).getValue();
        return v == PhTreeHelper.NULL ? null : (T)v;
    }

    @Override
    public PhEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        PhEntry<T> ret = this.resultToReturn;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class PhIteratorStack {
        private final NodeIteratorNoGC<T>[] stack = Refs.newArray(NodeIteratorNoGC.class, 64);
        private int size = 0;

        PhIteratorStack() {
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public NodeIteratorNoGC<T> prepareAndPush(Node node, long[] prefix) {
            NodeIteratorNoGC ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new NodeIteratorNoGC(PhIteratorNoGC.this.dims);
                this.stack[this.size - 1] = ni;
            }
            ni.init(PhIteratorNoGC.this.rangeMin, PhIteratorNoGC.this.rangeMax, node, PhIteratorNoGC.this.checker, prefix);
            return ni;
        }

        public NodeIteratorNoGC<T> peek() {
            return this.stack[this.size - 1];
        }

        public NodeIteratorNoGC<T> pop() {
            return this.stack[--this.size];
        }
    }
}

