/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13SynchedPool;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilterDistance;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.v13SynchedPool.Node;
import ch.ethz.globis.phtree.v13SynchedPool.NodeIteratorFullNoGC;
import ch.ethz.globis.phtree.v13SynchedPool.PhIteratorNoGC;
import ch.ethz.globis.phtree.v13SynchedPool.PhTree13SP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class PhQueryKnnMbbPP<T>
implements PhTree.PhKnnQuery<T> {
    private final int dims;
    private int nMin;
    private PhTree13SP<T> pht;
    private PhDistance distance;
    private final ArrayList<PhEntryDist<T>> entries = new ArrayList();
    private int resultSize = 0;
    private int currentPos = -1;
    private final long[] mbbMin;
    private final long[] mbbMax;
    private final PhIteratorNoGC<T> iter;
    private final PhFilterDistance checker;

    public PhQueryKnnMbbPP(PhTree13SP<T> pht) {
        this.dims = pht.getDim();
        this.mbbMin = new long[this.dims];
        this.mbbMax = new long[this.dims];
        this.pht = pht;
        this.checker = new PhFilterDistance();
        this.iter = new PhIteratorNoGC<T>(pht, this.checker);
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return new PhEntryDist(this.nextEntryReuse());
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        if (this.currentPos >= this.resultSize) {
            throw new NoSuchElementException();
        }
        return this.entries.get(this.currentPos++);
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.resultSize;
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.nMin = nMin;
        this.clearEntries();
        if (nMin > 0) {
            this.nearestNeighbourBinarySearch(center, nMin);
        }
        this.currentPos = 0;
        return this;
    }

    private void findKnnCandidate(long[] center, long[] ret) {
        this.findKnnCandidate(center, this.pht.getRoot(), ret);
    }

    private long[] findKnnCandidate(long[] key, Node node, long[] ret) {
        Object v = node.doIfMatching(key, true, null, null, null, this.pht);
        if (v == null) {
            return this.returnAnyValue(ret, key, node);
        }
        if (v instanceof Node) {
            return this.findKnnCandidate(key, (Node)v, ret);
        }
        if (this.nMin == 1) {
            System.arraycopy(key, 0, ret, 0, key.length);
            return ret;
        }
        return this.returnAnyValue(ret, key, node);
    }

    private long[] returnAnyValue(long[] ret, long[] key, Node node) {
        long mask = -1L << node.getPostLen() + 1;
        for (int i = 0; i < this.dims; ++i) {
            ret[i] = key[i] & mask;
        }
        NodeIteratorFullNoGC<Object> ni = new NodeIteratorFullNoGC<Object>(this.dims, ret);
        PhEntry<Object> result = new PhEntry<Object>(ret, null);
        ni.init(node, null);
        while (ni.increment(result)) {
            if (result.hasNodeInternal()) {
                ni.init((Node)result.getNodeInternal(), null);
                continue;
            }
            if (this.nMin > 1 && Arrays.equals(key, result.getKey())) continue;
            return ret;
        }
        throw new IllegalStateException();
    }

    private void nearestNeighbourBinarySearch(long[] val, int nMin) {
        if (nMin == 1 && this.pht.contains(val)) {
            this.addEntry(new PhEntry<T>(val, this.pht.get(val)), val);
            return;
        }
        if (this.pht.size() <= nMin) {
            PhTree.PhExtent<T> itEx = this.pht.queryExtent();
            while (itEx.hasNext()) {
                Object e = itEx.nextEntryReuse();
                this.addEntry((PhEntry<T>)e, val);
            }
            this.sortEntries();
            return;
        }
        long[] cand = new long[this.dims];
        this.findKnnCandidate(val, cand);
        double currentDist = this.distance.dist(val, cand);
        while (!this.findNeighbours(currentDist, nMin, val)) {
            currentDist *= 10.0;
        }
    }

    private final boolean findNeighbours(double maxDist, int nMin, long[] val) {
        double EPS = (double)this.dims * maxDist / 2.251799813685248E15;
        int CONSOLIDATION_INTERVAL = 10;
        this.clearEntries();
        this.checker.set(val, this.distance, maxDist);
        this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        this.iter.reset(this.mbbMin, this.mbbMax);
        while (this.iter.hasNext() && this.resultSize < nMin) {
            Object en = this.iter.nextEntryReuse();
            this.addEntry((PhEntry<T>)en, val);
        }
        this.sortEntries();
        if (this.resultSize < nMin) {
            return false;
        }
        if (!this.iter.hasNext()) {
            return true;
        }
        maxDist = this.entries.get(nMin - 1).dist();
        this.checker.set(val, this.distance, maxDist);
        this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        this.iter.adjustMinMax();
        int cnt = 0;
        while (this.iter.hasNext()) {
            Object e = this.iter.nextEntryReuse();
            this.addEntry((PhEntry<T>)e, val);
            if (++cnt % 10 != 0) continue;
            maxDist = this.consolidate(nMin, EPS, maxDist);
            this.checker.set(val, this.distance, maxDist);
            this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
            this.iter.adjustMinMax();
        }
        this.consolidate(nMin, EPS, maxDist);
        return true;
    }

    private double consolidate(int nMin, double eps, double max) {
        this.sortEntries();
        double maxDnew = this.entries.get(nMin - 1).dist();
        if (maxDnew < max + eps) {
            max = maxDnew;
            for (int i2 = nMin; i2 < this.resultSize; ++i2) {
                if (!(this.entries.get(i2).dist() + eps > max)) continue;
                this.resultSize = i2;
                break;
            }
        }
        return max;
    }

    private void addEntry(PhEntry<T> e, long[] center) {
        double dist = this.distance.dist(center, e.getKey());
        if (this.resultSize < this.entries.size()) {
            this.entries.get(this.resultSize).set(e, dist);
        } else {
            PhEntryDist<T> de = new PhEntryDist<T>(e, dist);
            this.entries.add(de);
        }
        ++this.resultSize;
    }

    private void clearEntries() {
        this.resultSize = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).clear();
        }
    }

    private void sortEntries() {
        this.entries.sort(PhEntryDist.COMP);
    }
}

