/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.shapefile;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.DbfFileReader;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeFileReader;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShpRecord;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShxFileReader;
import org.apache.sedona.sql.datasources.shapefile.ShapefilePartitionReader$;
import org.apache.sedona.sql.datasources.shapefile.ShapefileReadOptions;
import org.apache.sedona.sql.datasources.shapefile.ShapefileUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tUb\u0001B\u0014)\u0001UB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001dI\bA1A\u0005\niDq!a\b\u0001A\u0003%1\u0010C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011q\u0007\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011Q\u000b\u0001!\u0002\u0013\ti\u0004C\u0005\u0002X\u0001\u0011\r\u0011\"\u0003\u0002Z!A\u00111\r\u0001!\u0002\u0013\tY\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011\u0011\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002v!9\u0011q\u000f\u0001!\u0002\u00139\u0007\"CA=\u0001\t\u0007I\u0011BA>\u0011!\tI\t\u0001Q\u0001\n\u0005u\u0004\"CAF\u0001\t\u0007I\u0011BAG\u0011!\t)\f\u0001Q\u0001\n\u0005=\u0005\"CA\\\u0001\t\u0007I\u0011BA]\u0011!\ty\r\u0001Q\u0001\n\u0005m\u0006bCAi\u0001\u0001\u0007\t\u0019!C\u0005\u0003'D1\"!6\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\"Q\u00111\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B%\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\"9\u0011q\u001e\u0001\u0005B\u0005E\bbBAz\u0001\u0011\u0005\u0013Q_\u0004\b\u0003oD\u0003\u0012AA}\r\u00199\u0003\u0006#\u0001\u0002|\"1!/\tC\u0001\u0005\u0007A\u0011B!\u0002\"\u0005\u0004%\tAa\u0002\t\u0011\tU\u0011\u0005)A\u0005\u0005\u0013AqAa\u0006\"\t\u0013\u0011I\u0002C\u0004\u0003*\u0005\"IAa\u000b\u00031MC\u0017\r]3gS2,\u0007+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002*U\u0005I1\u000f[1qK\u001aLG.\u001a\u0006\u0003W1\n1\u0002Z1uCN|WO]2fg*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0019\u0019X\rZ8oC*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u001c?!\t9D(D\u00019\u0015\tI$(\u0001\u0003mC:<'\"A\u001e\u0002\t)\fg/Y\u0005\u0003{a\u0012aa\u00142kK\u000e$\bcA H\u00136\t\u0001I\u0003\u0002B\u0005\u0006!!/Z1e\u0015\t\u0019E)A\u0005d_:tWm\u0019;pe*\u0011Q&\u0012\u0006\u0003\rB\nQa\u001d9be.L!\u0001\u0013!\u0003\u001fA\u000b'\u000f^5uS>t'+Z1eKJ\u0004\"AS'\u000e\u0003-S!\u0001\u0014#\u0002\u0011\r\fG/\u00197zgRL!AT&\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B2p]\u001aT!!\u0016\u0019\u0002\r!\fGm\\8q\u0013\t9&KA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0011a\u0006\u0014H/\u001b;j_:,GMR5mKN\u00042AW/`\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&!B!se\u0006L\bC\u00011e\u001b\u0005\t'BA\u0016c\u0015\t\u0019G)A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Q-\u0019\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mK\u0006q!/Z1e\t\u0006$\u0018mU2iK6\f\u0007C\u00015l\u001b\u0005I'B\u00016E\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0017N\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa\u001c9uS>t7\u000f\u0005\u0002pa6\t\u0001&\u0003\u0002rQ\t!2\u000b[1qK\u001aLG.\u001a*fC\u0012|\u0005\u000f^5p]N\fa\u0001P5oSRtD#\u0002;vm^D\bCA8\u0001\u0011\u0015yU\u00011\u0001Q\u0011\u0015AV\u00011\u0001Z\u0011\u00151W\u00011\u0001h\u0011\u0015iW\u00011\u0001o\u0003M\u0001\u0018M\u001d;ji&|g.\u001a3GS2,7/T1q+\u0005Y\bc\u0002?\u0002\b\u00055\u00111\u0003\b\u0004{\u0006\r\u0001C\u0001@\\\u001b\u0005y(bAA\u0001i\u00051AH]8pizJ1!!\u0002\\\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u000bY\u0006c\u0001?\u0002\u0010%!\u0011\u0011CA\u0006\u0005\u0019\u0019FO]5oOB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001aQ\u000b!AZ:\n\t\u0005u\u0011q\u0003\u0002\u0005!\u0006$\b.\u0001\u000bqCJ$\u0018\u000e^5p]\u0016$g)\u001b7fg6\u000b\u0007\u000fI\u0001\u0004GB<WCAA\u0013!\u0015Q\u0016qEA\u0007\u0013\r\tIc\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002\t\r\u0004x\rI\u0001\u0004aJTWCAA\u0019!\u0015Q\u0016qEA\u001a!\r9\u0014QG\u0005\u0004\u0003#A\u0014\u0001\u00029sU\u0002\n\u0011b\u001d5q%\u0016\fG-\u001a:\u0016\u0005\u0005u\u0002\u0003BA \u0003#j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007g\"\f\u0007/Z:\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0010g\"\f\u0007/\u001a4jY\u0016\u0004\u0016M]:fe*!\u00111JA'\u000311wN]7bi6\u000b\u0007\u000f]3s\u0015\r\tyEL\u0001\u0005G>\u0014X-\u0003\u0003\u0002T\u0005\u0005#aD*iCB,g)\u001b7f%\u0016\fG-\u001a:\u0002\u0015MD\u0007OU3bI\u0016\u0014\b%A\u0005eE\u001a\u0014V-\u00193feV\u0011\u00111\f\t\u00065\u0006\u001d\u0012Q\f\t\u0005\u0003\u007f\ty&\u0003\u0003\u0002b\u0005\u0005#!\u0004#cM\u001aKG.\u001a*fC\u0012,'/\u0001\u0006eE\u001a\u0014V-\u00193fe\u0002\nQbZ3p[\u0016$(/\u001f$jK2$WCAA5!\u0015Q\u0016qEA6!\rA\u0017QN\u0005\u0004\u0003_J'aC*ueV\u001cGOR5fY\u0012\fabZ3p[\u0016$(/\u001f$jK2$\u0007%A\u0005tQB\u001c6\r[3nCV\tq-\u0001\u0006tQB\u001c6\r[3nC\u0002\n!\u0002\u001d:pU\u0016\u001cG/[8o+\t\ti\b\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iS\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\b\u0006\u0005%\u0001E+og\u00064W\r\u0015:pU\u0016\u001cG/[8o\u0003-\u0001(o\u001c6fGRLwN\u001c\u0011\u0002)\u0019LW\r\u001c3WC2,XmQ8om\u0016\u0014H/\u001a:t+\t\ty\t\u0005\u0004\u0002\u0012\u0006m\u0015\u0011\u0015\b\u0005\u0003'\u000b9JD\u0002\u007f\u0003+K\u0011\u0001X\u0005\u0004\u00033[\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003;\u000byJA\u0002TKFT1!!'\\!\u001dQ\u00161UAT\u0003_K1!!*\\\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003[;\u0006%\u0006c\u0001.\u0002,&\u0019\u0011QV.\u0003\t\tKH/\u001a\t\u00045\u0006E\u0016bAAZ7\n\u0019\u0011I\\=\u0002+\u0019LW\r\u001c3WC2,XmQ8om\u0016\u0014H/\u001a:tA\u0005yq-Z8nKR\u0014\u0018PR1di>\u0014\u00180\u0006\u0002\u0002<B!\u0011QXAf\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017\u0001B4f_6TA!!2\u0002H\u0006\u0019!\u000e^:\u000b\u0007\u0005%''\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007.\u0003\u0003\u0002N\u0006}&aD$f_6,GO]=GC\u000e$xN]=\u0002!\u001d,w.\\3uef4\u0015m\u0019;pef\u0004\u0013AC2veJ,g\u000e\u001e*poV\t\u0011*\u0001\bdkJ\u0014XM\u001c;S_^|F%Z9\u0015\t\u0005e\u0017q\u001c\t\u00045\u0006m\u0017bAAo7\n!QK\\5u\u0011!\t\toGA\u0001\u0002\u0004I\u0015a\u0001=%c\u0005Y1-\u001e:sK:$(k\\<!\u0003\u0011qW\r\u001f;\u0015\u0005\u0005%\bc\u0001.\u0002l&\u0019\u0011Q^.\u0003\u000f\t{w\u000e\\3b]\u0006\u0019q-\u001a;\u0015\u0003%\u000bQa\u00197pg\u0016$\"!!7\u00021MC\u0017\r]3gS2,\u0007+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u0002pCM\u0019\u0011%!@\u0011\u0007i\u000by0C\u0002\u0003\u0002m\u0013a!\u00118z%\u00164GCAA}\u0003\u0019awnZ4feV\u0011!\u0011\u0002\t\u0005\u0005\u0017\u0011\t\"\u0004\u0002\u0003\u000e)\u0019!q\u0002\u001a\u0002\u000bMdg\r\u000e6\n\t\tM!Q\u0002\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Qq\u000e]3o'R\u0014X-Y7\u0015\u0011\tm!\u0011\u0005B\u0012\u0005O\u0001B!!\u0006\u0003\u001e%!!qDA\f\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006s\u0016\u0002\ra\u001f\u0005\b\u0005K)\u0003\u0019AA\u0007\u0003%)\u0007\u0010^3og&|g\u000eC\u0003PK\u0001\u0007\u0001+A\u0007uef|\u0005/\u001a8TiJ,\u0017-\u001c\u000b\t\u0005[\u0011yC!\r\u00034A)!,a\n\u0003\u001c!)\u0011P\na\u0001w\"9!Q\u0005\u0014A\u0002\u00055\u0001\"B('\u0001\u0004\u0001\u0006")
public class ShapefilePartitionReader
implements PartitionReader<InternalRow> {
    private final Configuration configuration;
    private final StructType readDataSchema;
    private final ShapefileReadOptions options;
    private final Map<String, Path> partitionedFilesMap;
    private final Option<String> cpg;
    private final Option<String> prj;
    private final ShapeFileReader shpReader;
    private final Option<DbfFileReader> dbfReader;
    private final Option<StructField> geometryField;
    private final StructType shpSchema;
    private final UnsafeProjection projection;
    private final scala.collection.immutable.Seq<Function1<byte[], Object>> fieldValueConverters;
    private final GeometryFactory geometryFactory;
    private InternalRow currentRow;

    public static Logger logger() {
        return ShapefilePartitionReader$.MODULE$.logger();
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Map<String, Path> partitionedFilesMap() {
        return this.partitionedFilesMap;
    }

    private Option<String> cpg() {
        return this.cpg;
    }

    private Option<String> prj() {
        return this.prj;
    }

    private ShapeFileReader shpReader() {
        return this.shpReader;
    }

    private Option<DbfFileReader> dbfReader() {
        return this.dbfReader;
    }

    private Option<StructField> geometryField() {
        return this.geometryField;
    }

    private StructType shpSchema() {
        return this.shpSchema;
    }

    private UnsafeProjection projection() {
        return this.projection;
    }

    private scala.collection.immutable.Seq<Function1<byte[], Object>> fieldValueConverters() {
        return this.fieldValueConverters;
    }

    private GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    private InternalRow currentRow() {
        return this.currentRow;
    }

    private void currentRow_$eq(InternalRow x$1) {
        this.currentRow = x$1;
    }

    public boolean next() {
        if (this.shpReader().nextKeyValue()) {
            InternalRow internalRow;
            Seq seq;
            ShapeKey key = this.shpReader().getCurrentKey();
            long id = key.getIndex();
            Option attributesOpt = this.dbfReader().flatMap((Function1 & Serializable)reader -> {
                if (reader.nextKeyValue()) {
                    List value = reader.getCurrentFieldBytes();
                    return Option$.MODULE$.apply((Object)value);
                }
                Path dbfPath = (Path)this.partitionedFilesMap().get((Object)"dbf").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                ShapefilePartitionReader$.MODULE$.logger().warn("Shape record loses attributes in .dbf file {} at ID={}", (Object)dbfPath, (Object)BoxesRunTime.boxToLong((long)id));
                return None$.MODULE$;
            });
            ShpRecord value = this.shpReader().getCurrentValue();
            Option geometry = this.geometryField().flatMap((Function1 & Serializable)x$4 -> {
                if (value.getType().isSupported()) {
                    PrimitiveShape shape = new PrimitiveShape(value);
                    return new Some((Object)shape.getShape(this.geometryFactory()));
                }
                ShapefilePartitionReader$.MODULE$.logger().warn("Shape type {} is not supported, geometry value will be null", (Object)value.getType().name());
                return None$.MODULE$;
            });
            Option option = attributesOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                List fieldBytesList = (List)some.value();
                seq = (Seq)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fieldBytesList).asScala()).zip(this.fieldValueConverters())).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        byte[] fieldBytes = (byte[])tuple2._1();
                        Function1 converter = (Function1)tuple2._2();
                        return converter.apply((Object)fieldBytes);
                    }
                    throw new MatchError((Object)tuple2);
                });
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)package$.MODULE$.Seq().fill(this.fieldValueConverters().length(), (Function0 & Serializable)() -> null);
            } else {
                throw new MatchError((Object)option);
            }
            Seq attrValues = seq;
            byte[] serializedGeom = (byte[])geometry.map((Function1 & Serializable)obj -> GeometryUDT$.MODULE$.serialize(obj)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (this.options.keyFieldName().isDefined()) {
                byte[] byArray = serializedGeom;
                long l = key.getIndex();
                internalRow = InternalRow$.MODULE$.fromSeq((scala.collection.immutable.Seq)((SeqOps)attrValues.toSeq().$plus$colon((Object)BoxesRunTime.boxToLong((long)l))).$plus$colon((Object)byArray));
            } else {
                byte[] byArray = serializedGeom;
                internalRow = InternalRow$.MODULE$.fromSeq((scala.collection.immutable.Seq)attrValues.toSeq().$plus$colon((Object)byArray));
            }
            InternalRow shpRow = internalRow;
            this.currentRow_$eq((InternalRow)this.projection().apply(shpRow));
            return true;
        }
        this.dbfReader().foreach((Function1 & Serializable)reader -> {
            ShapefilePartitionReader.$anonfun$next$6(this, reader);
            return BoxedUnit.UNIT;
        });
        return false;
    }

    public InternalRow get() {
        return this.currentRow();
    }

    public void close() {
        this.dbfReader().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.shpReader().close();
    }

    public static final /* synthetic */ boolean $anonfun$geometryField$1(StructField x$1) {
        return x$1.dataType() instanceof GeometryUDT;
    }

    private final /* synthetic */ int liftedTree1$1(String wkt$1) {
        int n;
        try {
            n = FunctionsGeoTools.wktCRSToSRID((String)wkt$1);
        }
        catch (Throwable e) {
            Path prjPath = (Path)this.partitionedFilesMap().get((Object)"prj").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            ShapefilePartitionReader$.MODULE$.logger().warn(new StringBuilder(36).append("Failed to parse SRID from .prj file ").append(prjPath).toString(), e);
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$next$6(ShapefilePartitionReader $this, DbfFileReader reader) {
        if (reader.nextKeyValue()) {
            Path dbfPath = (Path)$this.partitionedFilesMap().get((Object)"dbf").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            ShapefilePartitionReader$.MODULE$.logger().warn("Redundant attributes in {} exists", (Object)dbfPath);
            return;
        }
    }

    public ShapefilePartitionReader(Configuration configuration, PartitionedFile[] partitionedFiles, StructType readDataSchema, ShapefileReadOptions options) {
        GeometryFactory geometryFactory;
        SeqOps seqOps;
        None$ none$;
        SeqOps seqOps2;
        ShapeFileReader shapeFileReader;
        this.configuration = configuration;
        this.readDataSchema = readDataSchema;
        this.options = options;
        this.partitionedFilesMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionedFiles), (Function1 & Serializable)file -> {
            String fileName = file.filePath().toPath().getName();
            String extension = FilenameUtils.getExtension((String)fileName).toLowerCase(Locale.ROOT);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)extension), (Object)file.filePath().toPath());
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.cpg = options.charset().orElse((Function0 & Serializable)() -> ShapefilePartitionReader$.MODULE$.org$apache$sedona$sql$datasources$shapefile$ShapefilePartitionReader$$tryOpenStream(this.partitionedFilesMap(), "cpg", $this.configuration).flatMap((Function1 & Serializable)stream -> {
            Object object;
            try {
                LineIterator lineIter = IOUtils.lineIterator((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                object = lineIter.hasNext() ? new Some((Object)lineIter.next().trim()) : None$.MODULE$;
            }
            finally {
                stream.close();
            }
            return object;
        }).orElse((Function0 & Serializable)() -> {
            String charset = System.getProperty("sedona.global.charset", "default");
            boolean utf8flag = charset.equalsIgnoreCase("utf8");
            if (utf8flag) {
                return new Some((Object)"UTF-8");
            }
            return None$.MODULE$;
        }));
        this.prj = ShapefilePartitionReader$.MODULE$.org$apache$sedona$sql$datasources$shapefile$ShapefilePartitionReader$$tryOpenStream(this.partitionedFilesMap(), "prj", configuration).map((Function1 & Serializable)stream -> {
            String string;
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            finally {
                stream.close();
            }
            return string;
        });
        Option<FSDataInputStream> option = ShapefilePartitionReader$.MODULE$.org$apache$sedona$sql$datasources$shapefile$ShapefilePartitionReader$$tryOpenStream(this.partitionedFilesMap(), "shx", configuration);
        if (option instanceof Some) {
            Some some = (Some)option;
            try (FSDataInputStream shxStream = (FSDataInputStream)some.value();){
                int[] index = ShxFileReader.readAll((DataInputStream)shxStream);
                shapeFileReader = new ShapeFileReader(index);
            }
        } else if (None$.MODULE$.equals(option)) {
            shapeFileReader = new ShapeFileReader();
        } else {
            throw new MatchError(option);
        }
        ShapeFileReader reader2 = shapeFileReader;
        FSDataInputStream stream2 = ShapefilePartitionReader$.MODULE$.org$apache$sedona$sql$datasources$shapefile$ShapefilePartitionReader$$openStream(this.partitionedFilesMap(), "shp", configuration);
        reader2.initialize(stream2);
        this.shpReader = reader2;
        this.dbfReader = ShapefilePartitionReader$.MODULE$.org$apache$sedona$sql$datasources$shapefile$ShapefilePartitionReader$$tryOpenStream(this.partitionedFilesMap(), "dbf", configuration).map((Function1 & Serializable)stream -> {
            DbfFileReader reader = new DbfFileReader();
            reader.initialize(stream);
            return reader;
        });
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)readDataSchema.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ShapefilePartitionReader.$anonfun$geometryField$1(x$1)));
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
            StructField geoField = (StructField)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            none$ = new Some((Object)geoField);
        } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalArgumentException("Only one geometry field is allowed");
        }
        this.geometryField = none$;
        scala.collection.immutable.Seq dbfFields = (scala.collection.immutable.Seq)this.dbfReader().map((Function1 & Serializable)reader -> ShapefileUtils$.MODULE$.fieldDescriptorsToStructFields((scala.collection.immutable.Seq<FieldDescriptor>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(reader.getFieldDescriptors()).asScala()).toSeq())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        this.shpSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ShapefileUtils$.MODULE$.baseSchema(options, ShapefileUtils$.MODULE$.baseSchema$default$2()).fields()), (IterableOnce)dbfFields, ClassTag$.MODULE$.apply(StructField.class)));
        scala.collection.immutable.Seq expressions = (scala.collection.immutable.Seq)readDataSchema.map((Function1 & Serializable)field -> {
            int index = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> this.shpSchema().fieldIndex(field.name())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            if (index >= 0) {
                StructField sourceField = this.shpSchema().fields()[index];
                BoundReference refExpr = new BoundReference(index, sourceField.dataType(), sourceField.nullable());
                DataType dataType = sourceField.dataType();
                DataType dataType2 = field.dataType();
                if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                    return refExpr;
                }
                return new Cast((Expression)refExpr, field.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            }
            if (field.nullable()) {
                return Literal$.MODULE$.apply(null);
            }
            Path dbfPath = (Path)this.partitionedFilesMap().get((Object)"dbf").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            throw new IllegalArgumentException(new StringBuilder(30).append("Field ").append(field.name()).append(" not found in shapefile ").append(dbfPath).toString());
        });
        this.projection = UnsafeProjection$.MODULE$.create(expressions);
        this.fieldValueConverters = (scala.collection.immutable.Seq)this.dbfReader().map((Function1 & Serializable)reader -> ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(reader.getFieldDescriptors()).asScala()).map((Function1 & Serializable)field -> {
            int index = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.readDataSchema.fieldIndex(field.getFieldName())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            if (index >= 0) {
                return ShapefileUtils$.MODULE$.fieldValueConverter((FieldDescriptor)field, this.cpg());
            }
            return (Function1 & Serializable)x$2 -> null;
        })).toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        Option<String> option2 = this.prj();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String wkt = (String)some.value();
            int srid = this.liftedTree1$1(wkt);
            geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        } else if (None$.MODULE$.equals(option2)) {
            geometryFactory = new GeometryFactory();
        } else {
            throw new MatchError(option2);
        }
        this.geometryFactory = geometryFactory;
    }
}

