/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.inputstream;

import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] bytes;

    public ByteArrayImageInputStream(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        if (this.streamPos >= (long)this.bytes.length) {
            return -1;
        }
        byte b = this.bytes[(int)this.streamPos++];
        return b & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (len == 0) {
            return 0;
        }
        int remaining = (int)((long)this.bytes.length - this.streamPos);
        if ((len = Math.min(len, remaining)) <= 0) {
            return -1;
        }
        System.arraycopy(this.bytes, (int)this.streamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }
}

