/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.rocketmq.client.java.route.Broker;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.shaded.com.google.common.base.Objects;
import org.apache.rocketmq.shaded.com.google.common.collect.ImmutableList;
import org.apache.rocketmq.shaded.com.google.common.hash.Hashing;
import org.apache.rocketmq.shaded.com.google.common.math.IntMath;
import org.apache.rocketmq.shaded.com.google.common.math.LongMath;
import org.apache.rocketmq.shaded.commons.lang3.RandomUtils;

@Immutable
public class PublishingLoadBalancer {
    private final AtomicInteger index;
    private final ImmutableList<MessageQueueImpl> messageQueues;

    public PublishingLoadBalancer(TopicRouteData topicRouteData) {
        this(new AtomicInteger(RandomUtils.nextInt(0, Integer.MAX_VALUE)), topicRouteData);
    }

    private PublishingLoadBalancer(AtomicInteger index, TopicRouteData topicRouteData) {
        this.index = index;
        List mqs = topicRouteData.getMessageQueues().stream().filter(mq -> mq.getPermission().isWritable() && 0 == mq.getBroker().getId()).collect(Collectors.toList());
        if (mqs.isEmpty()) {
            throw new IllegalArgumentException("No writable message queue found, topiRouteData=" + topicRouteData);
        }
        this.messageQueues = ((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)mqs)).build();
    }

    PublishingLoadBalancer update(TopicRouteData topicRouteData) {
        return new PublishingLoadBalancer(this.index, topicRouteData);
    }

    public MessageQueueImpl takeMessageQueueByMessageGroup(String messageGroup) {
        long hashCode = Hashing.sipHash24().hashBytes(messageGroup.getBytes(StandardCharsets.UTF_8)).asLong();
        int index = LongMath.mod(hashCode, this.messageQueues.size());
        return (MessageQueueImpl)this.messageQueues.get(index);
    }

    public List<MessageQueueImpl> takeMessageQueues(Set<Endpoints> excluded, int count) {
        String brokerName;
        Broker broker;
        MessageQueueImpl messageQueueImpl;
        int i;
        int next = this.index.getAndIncrement();
        ArrayList<MessageQueueImpl> candidates = new ArrayList<MessageQueueImpl>();
        HashSet<String> candidateBrokerNames = new HashSet<String>();
        for (i = 0; i < this.messageQueues.size(); ++i) {
            messageQueueImpl = (MessageQueueImpl)this.messageQueues.get(IntMath.mod(next++, this.messageQueues.size()));
            broker = messageQueueImpl.getBroker();
            brokerName = broker.getName();
            if (!excluded.contains(broker.getEndpoints()) && !candidateBrokerNames.contains(brokerName)) {
                candidateBrokerNames.add(brokerName);
                candidates.add(messageQueueImpl);
            }
            if (candidates.size() < count) continue;
            return candidates;
        }
        if (candidates.isEmpty()) {
            for (i = 0; i < this.messageQueues.size(); ++i) {
                if (!candidateBrokerNames.contains(brokerName = (broker = (messageQueueImpl = (MessageQueueImpl)this.messageQueues.get(IntMath.mod(next++, this.messageQueues.size()))).getBroker()).getName())) {
                    candidateBrokerNames.add(brokerName);
                    candidates.add(messageQueueImpl);
                }
                if (candidates.size() >= count) break;
            }
        }
        return candidates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishingLoadBalancer that = (PublishingLoadBalancer)o;
        return Objects.equal(this.messageQueues, that.messageQueues);
    }

    public int hashCode() {
        return Objects.hashCode(this.messageQueues);
    }
}

