/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;

public class ProducerSingleton {
    private static volatile Producer PRODUCER;
    private static volatile Producer TRANSACTIONAL_PRODUCER;
    private static final String ACCESS_KEY = "yourAccessKey";
    private static final String SECRET_KEY = "yourSecretKey";
    private static final String ENDPOINTS = "foobar.com:8080";

    private ProducerSingleton() {
    }

    private static Producer buildProducer(TransactionChecker checker, String ... topics) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        StaticSessionCredentialsProvider sessionCredentialsProvider = new StaticSessionCredentialsProvider(ACCESS_KEY, SECRET_KEY);
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(ENDPOINTS).setCredentialProvider(sessionCredentialsProvider).build();
        ProducerBuilder builder = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setTopics(topics);
        if (checker != null) {
            builder.setTransactionChecker(checker);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Producer getInstance(String ... topics) throws ClientException {
        if (null != PRODUCER) return PRODUCER;
        Class<ProducerSingleton> clazz = ProducerSingleton.class;
        synchronized (ProducerSingleton.class) {
            if (null != PRODUCER) return PRODUCER;
            PRODUCER = ProducerSingleton.buildProducer(null, topics);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PRODUCER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Producer getTransactionalInstance(TransactionChecker checker, String ... topics) throws ClientException {
        if (null != TRANSACTIONAL_PRODUCER) return TRANSACTIONAL_PRODUCER;
        Class<ProducerSingleton> clazz = ProducerSingleton.class;
        synchronized (ProducerSingleton.class) {
            if (null != TRANSACTIONAL_PRODUCER) return TRANSACTIONAL_PRODUCER;
            TRANSACTIONAL_PRODUCER = ProducerSingleton.buildProducer(checker, topics);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return TRANSACTIONAL_PRODUCER;
        }
    }
}

