/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc;

import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.grpc.ManagedChannel;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.DefaultGrpcExporterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.OkHttpGrpcExporterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;

final class GrpcExporterUtil {
    private static final boolean USE_OKHTTP;

    static <T extends Marshaler> GrpcExporterBuilder<T> exporterBuilder(String type, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<Function<ManagedChannel, MarshalerServiceStub<T, ?, ?>>> stubFactory, String grpcServiceName, String grpcEndpointPath) {
        if (USE_OKHTTP) {
            return new OkHttpGrpcExporterBuilder(type, grpcEndpointPath, defaultTimeoutSecs, defaultEndpoint);
        }
        return new DefaultGrpcExporterBuilder<T>(type, stubFactory.get(), defaultTimeoutSecs, defaultEndpoint, grpcServiceName);
    }

    static void logUnimplemented(Logger logger, String type, @Nullable String fullErrorMessage) {
        String envVar;
        switch (type) {
            case "span": {
                envVar = "OTLP_TRACES_EXPORTER";
                break;
            }
            case "metric": {
                envVar = "OTLP_METRICS_EXPORTER";
                break;
            }
            case "log": {
                envVar = "OTLP_LOGS_EXPORTER";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized type, this is a programming bug in the OpenTelemetry SDK");
            }
        }
        logger.log(Level.SEVERE, "Failed to export " + type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. If export is not desired and you are using OpenTelemetry autoconfiguration or the javaagent, disable export by setting " + envVar + "=none. Full error message: " + fullErrorMessage);
    }

    private GrpcExporterUtil() {
    }

    static {
        boolean useOkhttp = true;
        try {
            Class.forName("org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub");
            useOkhttp = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_OKHTTP = useOkhttp;
    }
}

