/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.consumer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import com.google.protobuf.util.Timestamps;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseWriter;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class ReceiveMessageResponseStreamWriter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected static final long NACK_INVISIBLE_TIME = Duration.ofSeconds(1L).toMillis();
    protected final MessagingProcessor messagingProcessor;
    protected final StreamObserver<ReceiveMessageResponse> streamObserver;

    public ReceiveMessageResponseStreamWriter(MessagingProcessor messagingProcessor, StreamObserver<ReceiveMessageResponse> observer) {
        this.messagingProcessor = messagingProcessor;
        this.streamObserver = observer;
    }

    public void writeAndComplete(ProxyContext ctx, ReceiveMessageRequest request, PopResult popResult) {
        this.writeAndComplete(ctx, request, popResult, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndComplete(ProxyContext ctx, ReceiveMessageRequest request, PopResult popResult, Runnable doAfterWrite) {
        PopStatus status = popResult.getPopStatus();
        List messageFoundList = popResult.getMsgFoundList();
        try {
            switch (status) {
                case FOUND: {
                    if (messageFoundList.isEmpty()) {
                        this.streamObserver.onNext((Object)ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.MESSAGE_NOT_FOUND, "no match message")).build());
                        break;
                    }
                    try {
                        this.streamObserver.onNext((Object)ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).build());
                    }
                    catch (Throwable t) {
                        messageFoundList.forEach(messageExt -> this.processThrowableWhenWriteMessage(t, ctx, request, (MessageExt)messageExt));
                        throw t;
                    }
                    Iterator<MessageExt> messageIterator = messageFoundList.iterator();
                    while (messageIterator.hasNext()) {
                        MessageExt curMessageExt = (MessageExt)messageIterator.next();
                        Message curMessage = this.convertToMessage(curMessageExt);
                        try {
                            this.streamObserver.onNext((Object)ReceiveMessageResponse.newBuilder().setMessage(curMessage).build());
                        }
                        catch (Throwable t) {
                            this.processThrowableWhenWriteMessage(t, ctx, request, curMessageExt);
                            messageIterator.forEachRemaining(messageExt -> this.processThrowableWhenWriteMessage(t, ctx, request, (MessageExt)messageExt));
                            this.onComplete();
                            return;
                        }
                    }
                    break;
                }
                case POLLING_FULL: {
                    this.streamObserver.onNext((Object)ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.TOO_MANY_REQUESTS, "polling full")).build());
                    break;
                }
                default: {
                    this.streamObserver.onNext((Object)ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.MESSAGE_NOT_FOUND, "no new message")).build());
                }
            }
            if (doAfterWrite != null) {
                doAfterWrite.run();
            }
        }
        catch (Throwable t) {
            this.writeResponseWithErrorIgnore(ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(t)).build());
        }
        finally {
            this.onComplete();
        }
    }

    protected Message convertToMessage(MessageExt messageExt) {
        return GrpcConverter.getInstance().buildMessage(messageExt);
    }

    protected void processThrowableWhenWriteMessage(Throwable throwable, ProxyContext ctx, ReceiveMessageRequest request, MessageExt messageExt) {
        String handle = messageExt.getProperty("POP_CK");
        if (handle == null) {
            return;
        }
        this.messagingProcessor.changeInvisibleTime(ctx, ReceiptHandle.decode((String)handle), messageExt.getMsgId(), request.getGroup().getName(), request.getMessageQueue().getTopic().getName(), NACK_INVISIBLE_TIME);
    }

    public void writeAndComplete(ProxyContext ctx, Code code, String message) {
        this.writeResponseWithErrorIgnore(ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(code, message)).build());
        this.onComplete();
    }

    public void writeAndComplete(ProxyContext ctx, ReceiveMessageRequest request, Throwable throwable) {
        this.writeResponseWithErrorIgnore(ReceiveMessageResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(throwable)).build());
        this.onComplete();
    }

    protected void writeResponseWithErrorIgnore(ReceiveMessageResponse response) {
        try {
            ResponseWriter.getInstance().writeResponse(this.streamObserver, response);
        }
        catch (Exception e) {
            log.error("err when write receive message response", (Throwable)e);
        }
    }

    protected void onComplete() {
        this.writeResponseWithErrorIgnore(ReceiveMessageResponse.newBuilder().setDeliveryTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).build());
        try {
            this.streamObserver.onCompleted();
        }
        catch (Exception e) {
            log.error("err when complete receive message response", (Throwable)e);
        }
    }
}

