/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.IndexedQueueSizeUtil;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MessagePassingQueueUtil;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueueProducerColdFields;
import org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import org.jctools.util.PortableJvmInfo;

abstract class BaseSpscLinkedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueueProducerColdFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    BaseSpscLinkedAtomicArrayQueue() {
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final void soNext(AtomicReferenceArray<E> curr, AtomicReferenceArray<E> next) {
        int offset = LinkedAtomicArrayQueueUtil.nextArrayOffset(curr);
        LinkedAtomicArrayQueueUtil.soElement(curr, offset, next);
    }

    protected final AtomicReferenceArray<E> lvNextArrayAndUnlink(AtomicReferenceArray<E> curr) {
        int offset = LinkedAtomicArrayQueueUtil.nextArrayOffset(curr);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)LinkedAtomicArrayQueueUtil.lvElement(curr, offset);
        LinkedAtomicArrayQueueUtil.soElement(curr, offset, null);
        return nextBuffer;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return MessagePassingQueueUtil.drain(this, c);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        for (int i = 0; i < limit; ++i) {
            AtomicReferenceArray buffer = this.producerBuffer;
            long index = this.producerIndex;
            long mask = this.producerMask;
            int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
            if (index < this.producerBufferLimit) {
                this.writeToQueue(buffer, s.get(), index, offset);
                continue;
            }
            if (this.offerColdPath(buffer, mask, index, offset, null, s)) continue;
            return i;
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, wait, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            while (this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0 && exit.keepRunning()) {
            }
            int idleCounter = 0;
            while (exit.keepRunning() && this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = wait.idle(idleCounter);
            }
        }
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.producerBuffer;
        long index = this.producerIndex;
        long mask = this.producerMask;
        int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
        if (index < this.producerBufferLimit) {
            this.writeToQueue(buffer, e, index, offset);
            return true;
        }
        return this.offerColdPath(buffer, mask, index, offset, e, null);
    }

    abstract boolean offerColdPath(AtomicReferenceArray<E> var1, long var2, long var4, int var6, E var7, MessagePassingQueue.Supplier<? extends E> var8);

    @Override
    public E poll() {
        boolean isNextBuffer;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == JUMP;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
            return e;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(buffer, index);
        }
        return null;
    }

    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
        Object e = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e == JUMP) {
            return this.newBufferPeek(buffer, index);
        }
        return e;
    }

    final void linkOldToNew(long currIndex, AtomicReferenceArray<E> oldBuffer, int offset, AtomicReferenceArray<E> newBuffer, int offsetInNew, E e) {
        LinkedAtomicArrayQueueUtil.soElement(newBuffer, offsetInNew, e);
        this.soNext(oldBuffer, newBuffer);
        LinkedAtomicArrayQueueUtil.soElement(oldBuffer, offset, JUMP);
        this.soProducerIndex(currIndex + 1L);
    }

    final void writeToQueue(AtomicReferenceArray<E> buffer, E e, long index, int offset) {
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
    }

    private E newBufferPeek(AtomicReferenceArray<E> buffer, long index) {
        long mask;
        AtomicReferenceArray<E> nextBuffer;
        this.consumerBuffer = nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerMask = mask = (long)(LinkedAtomicArrayQueueUtil.length(nextBuffer) - 2);
        int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
        return LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
    }

    private E newBufferPoll(AtomicReferenceArray<E> buffer, long index) {
        long mask;
        AtomicReferenceArray<E> nextBuffer;
        this.consumerBuffer = nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerMask = mask = (long)(LinkedAtomicArrayQueueUtil.length(nextBuffer) - 2);
        int offset = LinkedAtomicArrayQueueUtil.calcElementOffset(index, mask);
        E n = LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.soConsumerIndex(index + 1L);
        LinkedAtomicArrayQueueUtil.soElement(nextBuffer, offset, null);
        return n;
    }
}

