/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.Ints;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Platform;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.ThreadPoolMetricSet;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.concurrent.DefaultFixedThreadsExecutorGroupFactory;
import com.alipay.sofa.jraft.util.concurrent.FixedThreadsExecutorGroup;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final int CPUS = SystemPropertyUtil.getInt("jraft.available_processors", Runtime.getRuntime().availableProcessors());
    public static final int MIN_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.min", Utils.cpus());
    public static final int MAX_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.max", Math.max(100, Utils.cpus() * 5));
    public static final int APPEND_ENTRIES_THREADS_SEND = SystemPropertyUtil.getInt("jraft.append.entries.threads.send", Math.max(16, Ints.findNextPositivePowerOfTwo(Utils.cpus() * 2)));
    public static final int MAX_APPEND_ENTRIES_TASKS_PER_THREAD = SystemPropertyUtil.getInt("jraft.max.append.entries.tasks.per.thread", 32768);
    public static final boolean USE_MPSC_SINGLE_THREAD_EXECUTOR = SystemPropertyUtil.getBoolean("jraft.use.mpsc.single.thread.executor", true);
    @Deprecated
    private static ThreadPoolExecutor CLOSURE_EXECUTOR = ThreadPoolUtil.newBuilder().poolName("JRAFT_CLOSURE_EXECUTOR").enableMetric(true).coreThreads(MIN_CLOSURE_EXECUTOR_POOL_SIZE).maximumThreads(MAX_CLOSURE_EXECUTOR_POOL_SIZE).keepAliveSeconds(60L).workQueue(new SynchronousQueue<Runnable>()).threadFactory(new NamedThreadFactory("JRaft-Closure-Executor-", true)).build();
    private static final Pattern GROUP_ID_PATTER = Pattern.compile("^[a-zA-Z][a-zA-Z0-9\\-_]*$");
    public static final int RAFT_DATA_BUF_SIZE = SystemPropertyUtil.getInt("jraft.byte_buf.size", 1024);
    public static final int MAX_COLLECTOR_SIZE_PER_THREAD = SystemPropertyUtil.getInt("jraft.max_collector_size_per_thread", 256);
    public static final String IP_ANY = "0.0.0.0";
    public static final String IPV6_START_MARK = "[";
    public static final String IPV6_END_MARK = "]";
    private static final int IPV6_ADDRESS_LENGTH = 16;

    public static FixedThreadsExecutorGroup getDefaultAppendEntriesExecutor() {
        return AppendEntriesThreadPoolHolder.INSTANCE;
    }

    public static void verifyGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("Blank groupId");
        }
        if (!GROUP_ID_PATTER.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Invalid group id, it should be started with character 'a'-'z' or 'A'-'Z', and followed with numbers, english alphabet, '-' or '_'. ");
        }
    }

    @Deprecated
    public static void registerClosureExecutorMetrics(MetricRegistry registry) {
        registry.register("raft-utils-closure-thread-pool", (Metric)new ThreadPoolMetricSet(CLOSURE_EXECUTOR));
    }

    public static void runClosure(Closure done, Status status) {
        if (done != null) {
            done.run(status);
        }
    }

    @Deprecated
    public static Future<?> runClosureInThread(Closure done) {
        if (done == null) {
            return null;
        }
        return Utils.runClosureInThread(done, Status.OK());
    }

    @Deprecated
    public static Future<?> runInThread(Runnable runnable) {
        return CLOSURE_EXECUTOR.submit(runnable);
    }

    @Deprecated
    public static Future<?> runClosureInThread(final Closure done, final Status status) {
        if (done == null) {
            return null;
        }
        return Utils.runInThread(new Runnable(){

            @Override
            public void run() {
                try {
                    done.run(status);
                }
                catch (Throwable t) {
                    LOG.error("Fail to run done closure", t);
                }
            }
        });
    }

    public static int closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return 0;
        }
        try {
            closeable.close();
            return 0;
        }
        catch (IOException e) {
            LOG.error("Fail to close {}.", (Object)closeable, (Object)e);
            return RaftError.EIO.getNumber();
        }
    }

    public static int cpus() {
        return CPUS;
    }

    public static long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static ByteBuffer expandByteBuffer(ByteBuffer buf) {
        return Utils.expandByteBufferAtLeast(buf, RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public static ByteBuffer allocate() {
        return Utils.allocate(RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer expandByteBufferAtLeast(ByteBuffer buf, int minLength) {
        int newCapacity = minLength > RAFT_DATA_BUF_SIZE ? minLength : RAFT_DATA_BUF_SIZE;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        BufferUtils.flip(buf);
        newBuf.put(buf);
        return newBuf;
    }

    public static ByteBuffer expandByteBufferAtMost(ByteBuffer buf, int maxLength) {
        int newCapacity = maxLength > RAFT_DATA_BUF_SIZE || maxLength <= 0 ? RAFT_DATA_BUF_SIZE : maxLength;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        BufferUtils.flip(buf);
        newBuf.put(buf);
        return newBuf;
    }

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static long nowMs() {
        return System.currentTimeMillis();
    }

    public static long monotonicUs() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static <T> T withLockObject(T obj) {
        return Requires.requireNonNull(obj, "obj");
    }

    public static boolean atomicMoveFile(File source, File target, boolean sync) throws IOException {
        boolean success;
        Requires.requireNonNull(source, "source");
        Requires.requireNonNull(target, "target");
        Path sourcePath = source.toPath();
        Path targetPath = target.toPath();
        try {
            success = Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE) != null;
        }
        catch (IOException e) {
            if (e instanceof AtomicMoveNotSupportedException) {
                LOG.warn("Atomic move not supported, falling back to non-atomic move, error: {}.", (Object)e.getMessage());
            } else {
                LOG.error("Unable to move atomically, falling back to non-atomic move, error: {}.", (Throwable)e);
            }
            if (target.exists()) {
                LOG.info("The target file {} was already existing.", (Object)targetPath);
            }
            try {
                success = Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING) != null;
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                LOG.error("Unable to move {} to {}. Attempting to delete {} and abandoning.", new Object[]{sourcePath, targetPath, sourcePath, e1});
                try {
                    Files.deleteIfExists(sourcePath);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    LOG.error("Unable to delete {}, good bye then!", (Object)sourcePath, (Object)e2);
                    throw e2;
                }
                throw e1;
            }
        }
        if (success && sync) {
            File dir = target.getParentFile();
            Utils.fsync(dir);
        }
        return success;
    }

    public static void fsync(File file) throws IOException {
        boolean isDir = file.isDirectory();
        if (isDir && Platform.isWindows()) {
            LOG.warn("Unable to fsync directory {} on windows.", (Object)file);
            return;
        }
        try (FileChannel fc = FileChannel.open(file.toPath(), isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            fc.force(true);
        }
    }

    public static void unmap(MappedByteBuffer cb) {
        block5: {
            boolean isOldJDK = System.getProperty("java.specification.version", "99").startsWith("1.");
            try {
                Class<?> unsafeClass;
                if (isOldJDK) {
                    Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
                    cleaner.setAccessible(true);
                    Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                    clean.setAccessible(true);
                    clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
                    break block5;
                }
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Method clean = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                clean.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                clean.invoke(theUnsafe, cb);
            }
            catch (Exception ex) {
                LOG.error("Fail to un-mapped segment file.", (Throwable)ex);
            }
        }
    }

    public static String getString(byte[] bs, int off, int len) {
        return new String(bs, off, len, StandardCharsets.UTF_8);
    }

    public static boolean isIPv6(String addr) {
        try {
            return InetAddress.getByName(addr).getAddress().length == 16;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] parsePeerId(String s) {
        if (s.startsWith(IPV6_START_MARK) && StringUtils.containsIgnoreCase((String)s, (String)IPV6_END_MARK)) {
            String ipv6Addr = s.endsWith(IPV6_END_MARK) ? s : s.substring(0, s.indexOf(IPV6_END_MARK) + 1);
            if (!Utils.isIPv6(ipv6Addr)) {
                throw new IllegalArgumentException("The IPv6 address(\"" + ipv6Addr + "\") is incorrect.");
            }
            String tempString = s.substring(s.indexOf(ipv6Addr) + ipv6Addr.length());
            if (tempString.startsWith(":")) {
                tempString = tempString.substring(1);
            }
            String[] tempArr = StringUtils.splitPreserveAllTokens((String)tempString, (char)':');
            String[] result = new String[1 + tempArr.length];
            result[0] = ipv6Addr;
            System.arraycopy(tempArr, 0, result, 1, tempArr.length);
            return result;
        }
        return StringUtils.splitPreserveAllTokens((String)s, (char)':');
    }

    private static class AppendEntriesThreadPoolHolder {
        private static final FixedThreadsExecutorGroup INSTANCE = DefaultFixedThreadsExecutorGroupFactory.INSTANCE.newExecutorGroup(APPEND_ENTRIES_THREADS_SEND, "Append-Entries-Thread-Send", MAX_APPEND_ENTRIES_TASKS_PER_THREAD, true);

        private AppendEntriesThreadPoolHolder() {
        }
    }
}

