/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.core;

import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.rpc.Connection;
import com.alipay.sofa.jraft.rpc.RaftServerService;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.impl.ConnectionClosedEventListener;
import com.alipay.sofa.jraft.rpc.impl.core.NodeRequestProcessor;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.jraft.util.concurrent.ConcurrentHashSet;
import com.alipay.sofa.jraft.util.concurrent.MpscSingleThreadExecutor;
import com.alipay.sofa.jraft.util.concurrent.SingleThreadExecutor;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;

public class AppendEntriesRequestProcessor
extends NodeRequestProcessor<RpcRequests.AppendEntriesRequest>
implements ConnectionClosedEventListener {
    static final String PAIR_ATTR = "jraft-peer-pairs";
    private final Map<String, Map<String, PeerPair>> pairConstants = new HashMap<String, Map<String, PeerPair>>();
    private final ConcurrentMap<String, ConcurrentMap<PeerPair, PeerRequestContext>> peerRequestContexts = new ConcurrentHashMap<String, ConcurrentMap<PeerPair, PeerRequestContext>>();
    private final RpcProcessor.ExecutorSelector executorSelector = new PeerExecutorSelector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerPair pairOf(String peerId, String serverId) {
        Map<String, Map<String, PeerPair>> map = this.pairConstants;
        synchronized (map) {
            Map pairs = this.pairConstants.computeIfAbsent(peerId, k -> new HashMap());
            PeerPair pair = pairs.computeIfAbsent(serverId, k -> new PeerPair(peerId, serverId));
            return pair;
        }
    }

    PeerRequestContext getPeerRequestContext(String groupId, PeerPair pair) {
        ConcurrentMap groupContexts = (ConcurrentMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null) {
            return null;
        }
        return (PeerRequestContext)groupContexts.get(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSequenceResponse(String groupId, PeerPair pair, int seq, RpcContext rpcCtx, Message msg) {
        PeerRequestContext ctx = this.getPeerRequestContext(groupId, pair);
        if (ctx == null) {
            return;
        }
        PriorityQueue respQueue = ctx.responseQueue;
        assert (respQueue != null);
        PriorityQueue priorityQueue = Utils.withLockObject(respQueue);
        synchronized (priorityQueue) {
            respQueue.add(new SequenceMessage(rpcCtx, msg, seq));
            if (!ctx.hasTooManyPendingResponses()) {
                SequenceMessage queuedPipelinedResponse;
                while (!respQueue.isEmpty() && (queuedPipelinedResponse = (SequenceMessage)respQueue.peek()).sequence == ctx.getNextRequiredSequence()) {
                    respQueue.remove();
                    try {
                        queuedPipelinedResponse.sendResponse();
                    }
                    finally {
                        ctx.getAndIncrementNextRequiredSequence();
                    }
                }
            } else {
                Connection connection = rpcCtx.getConnection();
                LOG.warn("Closed connection to peer {}/{}, because of too many pending responses, queued={}, max={}", new Object[]{ctx.groupId, pair, respQueue.size(), ctx.maxPendingResponses});
                connection.close();
                this.removePeerRequestContext(groupId, pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerRequestContext getOrCreatePeerRequestContext(String groupId, PeerPair pair, Connection conn) {
        PeerRequestContext peerCtx;
        ConcurrentMap existsCtxs;
        ConcurrentMap<PeerPair, PeerRequestContext> groupContexts = (ConcurrentHashMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null && (existsCtxs = (ConcurrentMap)this.peerRequestContexts.putIfAbsent(groupId, groupContexts = new ConcurrentHashMap())) != null) {
            groupContexts = existsCtxs;
        }
        if ((peerCtx = (PeerRequestContext)groupContexts.get(pair)) == null) {
            ConcurrentMap concurrentMap = Utils.withLockObject(groupContexts);
            synchronized (concurrentMap) {
                peerCtx = (PeerRequestContext)groupContexts.get(pair);
                if (peerCtx == null) {
                    PeerId peer = new PeerId();
                    boolean parsed = peer.parse(pair.local);
                    assert (parsed);
                    Node node = NodeManager.getInstance().get(groupId, peer);
                    assert (node != null);
                    peerCtx = new PeerRequestContext(groupId, pair, node.getRaftOptions().getMaxReplicatorInflightMsgs());
                    groupContexts.put(pair, peerCtx);
                }
            }
        }
        if (conn != null) {
            Set existsPairs;
            Set<PeerPair> pairs = (ConcurrentHashSet<PeerPair>)conn.getAttribute(PAIR_ATTR);
            if (pairs == null && (existsPairs = (Set)conn.setAttributeIfAbsent(PAIR_ATTR, pairs = new ConcurrentHashSet<PeerPair>())) != null) {
                pairs = existsPairs;
            }
            pairs.add(pair);
        }
        return peerCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePeerRequestContext(String groupId, PeerPair pair) {
        ConcurrentMap groupContexts = (ConcurrentMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null) {
            return;
        }
        ConcurrentMap concurrentMap = Utils.withLockObject(groupContexts);
        synchronized (concurrentMap) {
            PeerRequestContext ctx = (PeerRequestContext)groupContexts.remove(pair);
            if (ctx != null) {
                ctx.destroy();
            }
        }
    }

    public AppendEntriesRequestProcessor(Executor executor) {
        super(executor, (Message)RpcRequests.AppendEntriesResponse.getDefaultInstance());
    }

    @Override
    protected String getPeerId(RpcRequests.AppendEntriesRequest request) {
        return request.getPeerId();
    }

    @Override
    protected String getGroupId(RpcRequests.AppendEntriesRequest request) {
        return request.getGroupId();
    }

    private int getAndIncrementSequence(String groupId, PeerPair pair, Connection conn) {
        return this.getOrCreatePeerRequestContext(groupId, pair, conn).getAndIncrementSequence();
    }

    private boolean isHeartbeatRequest(RpcRequests.AppendEntriesRequest request) {
        return request.getEntriesCount() == 0 && !request.hasData();
    }

    @Override
    public Message processRequest0(RaftServerService service, RpcRequests.AppendEntriesRequest request, RpcRequestClosure done) {
        Node node = (Node)((Object)service);
        if (node.getRaftOptions().isReplicatorPipeline()) {
            Message response;
            String groupId = request.getGroupId();
            PeerPair pair = this.pairOf(request.getPeerId(), request.getServerId());
            boolean isHeartbeat = this.isHeartbeatRequest(request);
            int reqSequence = -1;
            if (!isHeartbeat) {
                reqSequence = this.getAndIncrementSequence(groupId, pair, done.getRpcCtx().getConnection());
            }
            if ((response = service.handleAppendEntriesRequest(request, new SequenceRpcRequestClosure(done, this.defaultResp(), groupId, pair, reqSequence, isHeartbeat))) != null) {
                if (isHeartbeat) {
                    done.getRpcCtx().sendResponse(response);
                } else {
                    this.sendSequenceResponse(groupId, pair, reqSequence, done.getRpcCtx(), response);
                }
            }
            return null;
        }
        return service.handleAppendEntriesRequest(request, done);
    }

    @Override
    public String interest() {
        return RpcRequests.AppendEntriesRequest.class.getName();
    }

    @Override
    public RpcProcessor.ExecutorSelector executorSelector() {
        return this.executorSelector;
    }

    public void destroy() {
        for (ConcurrentMap map : this.peerRequestContexts.values()) {
            for (PeerRequestContext ctx : map.values()) {
                ctx.destroy();
            }
        }
        this.peerRequestContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed(String remoteAddress, Connection conn) {
        Set pairs = (Set)conn.getAttribute(PAIR_ATTR);
        if (pairs != null && !pairs.isEmpty()) {
            for (Map.Entry entry : this.peerRequestContexts.entrySet()) {
                ConcurrentMap groupCtxs = (ConcurrentMap)entry.getValue();
                ConcurrentMap concurrentMap = Utils.withLockObject(groupCtxs);
                synchronized (concurrentMap) {
                    for (PeerPair pair : pairs) {
                        PeerRequestContext ctx = (PeerRequestContext)groupCtxs.remove(pair);
                        if (ctx == null) continue;
                        ctx.destroy();
                    }
                }
            }
        } else {
            LOG.info("Connection disconnected: {}", (Object)remoteAddress);
        }
    }

    static class PeerRequestContext {
        private final String groupId;
        private final PeerPair pair;
        private SingleThreadExecutor executor;
        private int sequence;
        private int nextRequiredSequence;
        private final PriorityQueue<SequenceMessage> responseQueue;
        private final int maxPendingResponses;

        public PeerRequestContext(String groupId, PeerPair pair, int maxPendingResponses) {
            this.pair = pair;
            this.groupId = groupId;
            this.executor = new MpscSingleThreadExecutor(Utils.MAX_APPEND_ENTRIES_TASKS_PER_THREAD, JRaftUtils.createThreadFactory(groupId + "/" + pair + "-AppendEntriesThread"));
            this.sequence = 0;
            this.nextRequiredSequence = 0;
            this.maxPendingResponses = maxPendingResponses;
            this.responseQueue = new PriorityQueue(50);
        }

        boolean hasTooManyPendingResponses() {
            return this.responseQueue.size() > this.maxPendingResponses;
        }

        int getAndIncrementSequence() {
            int prev = this.sequence++;
            if (this.sequence < 0) {
                this.sequence = 0;
            }
            return prev;
        }

        synchronized void destroy() {
            if (this.executor != null) {
                LOG.info("Destroyed peer request context for {}/{}", (Object)this.groupId, (Object)this.pair);
                this.executor.shutdownGracefully();
                this.executor = null;
            }
        }

        int getNextRequiredSequence() {
            return this.nextRequiredSequence;
        }

        int getAndIncrementNextRequiredSequence() {
            int prev = this.nextRequiredSequence++;
            if (this.nextRequiredSequence < 0) {
                this.nextRequiredSequence = 0;
            }
            return prev;
        }
    }

    static class PeerPair {
        final String local;
        final String remote;

        PeerPair(String local, String remote) {
            this.local = local;
            this.remote = remote;
        }

        public String toString() {
            return "PeerPair[" + this.local + " -> " + this.remote + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
            result = 31 * result + (this.remote == null ? 0 : this.remote.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerPair other = (PeerPair)obj;
            if (this.local == null ? other.local != null : !this.local.equals(other.local)) {
                return false;
            }
            return !(this.remote == null ? other.remote != null : !this.remote.equals(other.remote));
        }
    }

    static class SequenceMessage
    implements Comparable<SequenceMessage> {
        public final Message msg;
        private final int sequence;
        private final RpcContext rpcCtx;

        public SequenceMessage(RpcContext rpcCtx, Message msg, int sequence) {
            this.rpcCtx = rpcCtx;
            this.msg = msg;
            this.sequence = sequence;
        }

        void sendResponse() {
            this.rpcCtx.sendResponse(this.msg);
        }

        @Override
        public int compareTo(SequenceMessage o) {
            return Integer.compare(this.sequence, o.sequence);
        }
    }

    class SequenceRpcRequestClosure
    extends RpcRequestClosure {
        private final int reqSequence;
        private final String groupId;
        private final PeerPair pair;
        private final boolean isHeartbeat;

        public SequenceRpcRequestClosure(RpcRequestClosure parent, Message defaultResp, String groupId, PeerPair pair, int sequence, boolean isHeartbeat) {
            super(parent.getRpcCtx(), defaultResp);
            this.reqSequence = sequence;
            this.groupId = groupId;
            this.pair = pair;
            this.isHeartbeat = isHeartbeat;
        }

        @Override
        public void sendResponse(Message msg) {
            if (this.isHeartbeat) {
                super.sendResponse(msg);
            } else {
                AppendEntriesRequestProcessor.this.sendSequenceResponse(this.groupId, this.pair, this.reqSequence, this.getRpcCtx(), msg);
            }
        }
    }

    final class PeerExecutorSelector
    implements RpcProcessor.ExecutorSelector {
        PeerExecutorSelector() {
        }

        @Override
        public Executor select(String reqClass, Object reqHeader) {
            RpcRequests.AppendEntriesRequestHeader header = (RpcRequests.AppendEntriesRequestHeader)reqHeader;
            String groupId = header.getGroupId();
            String peerId = header.getPeerId();
            String serverId = header.getServerId();
            PeerId peer = new PeerId();
            if (!peer.parse(peerId)) {
                return AppendEntriesRequestProcessor.this.executor();
            }
            Node node = NodeManager.getInstance().get(groupId, peer);
            if (node == null || !node.getRaftOptions().isReplicatorPipeline()) {
                return AppendEntriesRequestProcessor.this.executor();
            }
            RpcFactoryHelper.rpcFactory().ensurePipeline();
            PeerRequestContext ctx = AppendEntriesRequestProcessor.this.getOrCreatePeerRequestContext(groupId, AppendEntriesRequestProcessor.this.pairOf(peerId, serverId), null);
            return ctx.executor;
        }
    }
}

