/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.ha.io.HAWriteHook;

public class HAWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final List<HAWriteHook> writeHookList = new ArrayList<HAWriteHook>();

    public boolean write(SocketChannel socketChannel, ByteBuffer byteBufferWrite) throws IOException {
        int writeSizeZeroTimes = 0;
        while (byteBufferWrite.hasRemaining()) {
            int writeSize = socketChannel.write(byteBufferWrite);
            for (HAWriteHook writeHook : this.writeHookList) {
                writeHook.afterWrite(writeSize);
            }
            if (writeSize > 0) {
                writeSizeZeroTimes = 0;
                continue;
            }
            if (writeSize == 0) {
                if (++writeSizeZeroTimes < 3) continue;
                break;
            }
            LOGGER.info("Write socket < 0");
        }
        return !byteBufferWrite.hasRemaining();
    }

    public void registerHook(HAWriteHook writeHook) {
        this.writeHookList.add(writeHook);
    }

    public void clearHook() {
        this.writeHookList.clear();
    }
}

