/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUringSupport {
    private static final Logger LOG;
    public static final String NAME = "IO_URING";
    private static final boolean AVAILABLE;
    private static final boolean INCUBATOR_VARIANT;
    private static final Class<? extends Channel> SOCKET_CHANNEL_CLASS;
    private static final Constructor<?> EVENTLOOP_CONSTRUCTOR;
    private static final Method IOHANDLER_FACTORY;

    public static boolean isAvailable(TransportOptions transportOptions) {
        return transportOptions.allowNativeIO() && AVAILABLE;
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        IOUringSupport.ensureAvailability();
        Exception createError = null;
        if (INCUBATOR_VARIANT) {
            try {
                return (EventLoopGroup)EVENTLOOP_CONSTRUCTOR.newInstance(nThreads, ioThreadFactory);
            }
            catch (Exception e) {
                LOG.debug("Unable to create Netty incubator io_uring EventLoopGroup due to error", (Throwable)e);
                createError = e;
            }
        } else {
            try {
                return (EventLoopGroup)EVENTLOOP_CONSTRUCTOR.newInstance(nThreads, ioThreadFactory, IOHANDLER_FACTORY.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                LOG.debug("Unable to create Netty io_uring EventLoopGroup due to error", (Throwable)e);
                createError = e;
            }
        }
        throw (Error)new UnsupportedOperationException("Netty io_uring failed to create resource").initCause(createError);
    }

    public static Class<? extends Channel> getChannelClass() {
        IOUringSupport.ensureAvailability();
        return SOCKET_CHANNEL_CLASS;
    }

    public static void ensureAvailability() {
        if (!AVAILABLE) {
            throw new UnsupportedOperationException("Netty io_ring support is not enabled because the Netty library indicates it is not present or disabled");
        }
    }

    static {
        Class<?> eventLoopGroup;
        Method isAvailable;
        Class<?> ioUring;
        LOG = LoggerFactory.getLogger(IOUringSupport.class);
        boolean available = false;
        boolean incubator = false;
        Class<?> socketChannelClass = null;
        Constructor<?> constructor = null;
        Method ioHandlerFactory = null;
        try {
            ioUring = Class.forName("io.netty.channel.uring.IoUring");
            isAvailable = ioUring.getDeclaredMethod("isAvailable", null);
            eventLoopGroup = Class.forName("io.netty.channel.MultiThreadIoEventLoopGroup");
            Class<?> ioUringHandler = Class.forName("io.netty.channel.uring.IoUringIoHandler");
            Class<?> ioUringHandlerFactory = Class.forName("io.netty.channel.IoHandlerFactory");
            constructor = eventLoopGroup.getDeclaredConstructor(Integer.TYPE, ThreadFactory.class, ioUringHandlerFactory);
            ioHandlerFactory = ioUringHandler.getDeclaredMethod("newFactory", new Class[0]);
            socketChannelClass = Class.forName("io.netty.channel.uring.IoUringSocketChannel");
            available = (Boolean)isAvailable.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.debug("Unable to enable netty io_uring support due to error", (Throwable)e);
        }
        if (!available) {
            try {
                ioUring = Class.forName("io.netty.incubator.channel.uring.IOUring");
                isAvailable = ioUring.getDeclaredMethod("isAvailable", new Class[0]);
                eventLoopGroup = Class.forName("io.netty.incubator.channel.uring.IOUringEventLoopGroup");
                socketChannelClass = Class.forName("io.netty.incubator.channel.uring.IOUringSocketChannel");
                constructor = eventLoopGroup.getDeclaredConstructor(Integer.TYPE, ThreadFactory.class);
                available = (Boolean)isAvailable.invoke(null, new Object[0]);
                incubator = true;
            }
            catch (Exception e) {
                LOG.debug("Unable to enable netty incubator io_uring support due to error", (Throwable)e);
            }
        }
        AVAILABLE = available;
        INCUBATOR_VARIANT = incubator;
        SOCKET_CHANNEL_CLASS = socketChannelClass;
        EVENTLOOP_CONSTRUCTOR = constructor;
        IOHANDLER_FACTORY = ioHandlerFactory;
    }
}

