/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class AllResultColumn
extends ResultColumn {
    private TableName tableName;

    AllResultColumn(TableName tableName, ContextManager contextManager) {
        super(contextManager);
        this.tableName = tableName;
    }

    String getFullTableName() {
        if (this.tableName == null) {
            return null;
        }
        return this.tableName.getFullTableName();
    }

    @Override
    ResultColumn cloneMe() throws StandardException {
        return new AllResultColumn(this.tableName, this.getContextManager());
    }

    @Override
    public TableName getTableNameObject() {
        return this.tableName;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

