/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.net.URL;
import java.time.Clock;
import java.time.Duration;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.impl.auth.oauth2.AuthenticationOAuth2;
import org.apache.pulsar.client.impl.auth.oauth2.ClientCredentialsFlow;

public final class AuthenticationFactoryOAuth2 {
    public static Authentication clientCredentials(URL issuerUrl, URL credentialsUrl, String audience) {
        return AuthenticationFactoryOAuth2.clientCredentials(issuerUrl, credentialsUrl, audience, null);
    }

    public static Authentication clientCredentials(URL issuerUrl, URL credentialsUrl, String audience, String scope) {
        return AuthenticationFactoryOAuth2.clientCredentialsBuilder().issuerUrl(issuerUrl).credentialsUrl(credentialsUrl).audience(audience).scope(scope).build();
    }

    public static ClientCredentialsBuilder clientCredentialsBuilder() {
        return new ClientCredentialsBuilder();
    }

    public static ClientCredentialsBuilder clientCredentialsWithStandardAuthzServerBuilder() {
        return new ClientCredentialsBuilder().wellKnownMetadataPath("/.well-known/oauth-authorization-server");
    }

    public static class ClientCredentialsBuilder {
        private URL issuerUrl;
        private URL credentialsUrl;
        private String audience;
        private String scope;
        private Duration connectTimeout;
        private Duration readTimeout;
        private String trustCertsFilePath;
        private String wellKnownMetadataPath;

        private ClientCredentialsBuilder() {
        }

        public ClientCredentialsBuilder issuerUrl(URL issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public ClientCredentialsBuilder credentialsUrl(URL credentialsUrl) {
            this.credentialsUrl = credentialsUrl;
            return this;
        }

        public ClientCredentialsBuilder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public ClientCredentialsBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public ClientCredentialsBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ClientCredentialsBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ClientCredentialsBuilder trustCertsFilePath(String trustCertsFilePath) {
            this.trustCertsFilePath = trustCertsFilePath;
            return this;
        }

        public ClientCredentialsBuilder wellKnownMetadataPath(String wellKnownMetadataPath) {
            this.wellKnownMetadataPath = wellKnownMetadataPath;
            return this;
        }

        public Authentication build() {
            ClientCredentialsFlow flow = ClientCredentialsFlow.builder().issuerUrl(this.issuerUrl).privateKey(this.credentialsUrl == null ? null : this.credentialsUrl.toExternalForm()).audience(this.audience).scope(this.scope).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).trustCertsFilePath(this.trustCertsFilePath).wellKnownMetadataPath(this.wellKnownMetadataPath).build();
            return new AuthenticationOAuth2(flow, Clock.systemDefaultZone());
        }
    }
}

