/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.ServiceHelper;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Vertx;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.file.impl.FileResolverImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.transports.EpollTransport;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.transports.JDKTransport;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.transports.KQueueTransport;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.metrics.MetricsOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.ExecutorServiceFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxMetricsFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxServiceProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxThreadFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.VertxTracerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.cluster.ClusterManager;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.cluster.NodeSelector;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.cluster.impl.DefaultNodeSelector;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.file.FileResolver;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.VertxMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.VertxTracer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.transport.Transport;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.tracing.TracingOptions;

public class VertxBuilder {
    private static final Logger log = LoggerFactory.getLogger(VertxBuilder.class);
    private VertxOptions options;
    private JsonObject config;
    private Transport transport;
    private ClusterManager clusterManager;
    private NodeSelector clusterNodeSelector;
    private VertxTracer tracer;
    private VertxThreadFactory threadFactory;
    private ExecutorServiceFactory executorServiceFactory;
    private VertxMetrics metrics;
    private FileResolver fileResolver;

    public VertxBuilder(JsonObject config) {
        this(new VertxOptions(config));
        this.config = config;
    }

    public VertxBuilder(VertxOptions options) {
        this.options = options;
    }

    public VertxBuilder() {
        this(new VertxOptions());
    }

    public VertxOptions options() {
        return this.options;
    }

    public JsonObject config() {
        return this.config;
    }

    public Transport findTransport() {
        return this.transport;
    }

    public VertxBuilder findTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public ClusterManager clusterManager() {
        return this.clusterManager;
    }

    public VertxBuilder clusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        return this;
    }

    public NodeSelector clusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public VertxBuilder clusterNodeSelector(NodeSelector selector) {
        this.clusterNodeSelector = selector;
        return this;
    }

    public VertxTracer tracer() {
        return this.tracer;
    }

    public VertxBuilder tracer(VertxTracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public VertxMetrics metrics() {
        return this.metrics;
    }

    public VertxBuilder metrics(VertxMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public FileResolver fileResolver() {
        return this.fileResolver;
    }

    public VertxBuilder fileResolver(FileResolver resolver) {
        this.fileResolver = resolver;
        return this;
    }

    public VertxThreadFactory threadFactory() {
        return this.threadFactory;
    }

    public VertxBuilder threadFactory(VertxThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    public ExecutorServiceFactory executorServiceFactory() {
        return this.executorServiceFactory;
    }

    public VertxBuilder executorServiceFactory(ExecutorServiceFactory factory) {
        this.executorServiceFactory = factory;
        return this;
    }

    public Vertx vertx() {
        this.checkBeforeInstantiating();
        VertxImpl vertx = new VertxImpl(this.options, null, null, this.metrics, this.tracer, this.transport, this.fileResolver, this.threadFactory, this.executorServiceFactory);
        vertx.init();
        return vertx;
    }

    public void clusteredVertx(Handler<AsyncResult<Vertx>> handler) {
        this.checkBeforeInstantiating();
        if (this.clusterManager == null) {
            throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
        }
        VertxImpl vertx = new VertxImpl(this.options, this.clusterManager, this.clusterNodeSelector == null ? new DefaultNodeSelector() : this.clusterNodeSelector, this.metrics, this.tracer, this.transport, this.fileResolver, this.threadFactory, this.executorServiceFactory);
        vertx.initClustered(this.options, handler);
    }

    public VertxBuilder init() {
        this.initTransport();
        ArrayList<VertxServiceProvider> providers = new ArrayList<VertxServiceProvider>();
        VertxBuilder.initMetrics(this.options, providers);
        VertxBuilder.initTracing(this.options, providers);
        VertxBuilder.initClusterManager(this.options, providers);
        providers.addAll(ServiceHelper.loadFactories(VertxServiceProvider.class));
        this.initProviders(providers);
        this.initThreadFactory();
        this.initExecutorServiceFactory();
        this.initFileResolver();
        return this;
    }

    private void initProviders(Collection<VertxServiceProvider> providers) {
        for (VertxServiceProvider provider : providers) {
            provider.init(this);
        }
    }

    private static void initMetrics(VertxOptions options, Collection<VertxServiceProvider> providers) {
        VertxMetricsFactory factory;
        MetricsOptions metricsOptions = options.getMetricsOptions();
        if (metricsOptions != null && (factory = metricsOptions.getFactory()) != null) {
            providers.add(factory);
        }
    }

    private static void initTracing(VertxOptions options, Collection<VertxServiceProvider> providers) {
        VertxTracerFactory factory;
        TracingOptions tracingOptions = options.getTracingOptions();
        if (tracingOptions != null && (factory = tracingOptions.getFactory()) != null) {
            providers.add(factory);
        }
    }

    private static void initClusterManager(VertxOptions options, Collection<VertxServiceProvider> providers) {
        String clusterManagerClassName;
        ClusterManager clusterManager = options.getClusterManager();
        if (clusterManager == null && (clusterManagerClassName = System.getProperty("vertx.cluster.managerClass")) != null) {
            try {
                Class<?> clazz = Class.forName(clusterManagerClassName);
                clusterManager = (ClusterManager)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate " + clusterManagerClassName, e);
            }
        }
        if (clusterManager != null) {
            providers.add(clusterManager);
        }
    }

    private void initTransport() {
        if (this.transport != null) {
            return;
        }
        this.transport = VertxBuilder.findTransport(this.options.getPreferNativeTransport());
    }

    private void initFileResolver() {
        if (this.fileResolver != null) {
            return;
        }
        this.fileResolver = new FileResolverImpl(this.options.getFileSystemOptions());
    }

    private void initThreadFactory() {
        if (this.threadFactory != null) {
            return;
        }
        this.threadFactory = VertxThreadFactory.INSTANCE;
    }

    private void initExecutorServiceFactory() {
        if (this.executorServiceFactory != null) {
            return;
        }
        this.executorServiceFactory = ExecutorServiceFactory.INSTANCE;
    }

    private void checkBeforeInstantiating() {
        this.checkTracing();
        this.checkMetrics();
    }

    private void checkTracing() {
        if (this.options.getTracingOptions() != null && this.tracer == null) {
            log.warn("Tracing options are configured but no tracer is instantiated. Make sure you have the VertxTracerFactory in your classpath and META-INF/services/io.vertx.core.spi.VertxServiceProvider contains the factory FQCN, or tracingOptions.getFactory() returns a non null value");
        }
    }

    private void checkMetrics() {
        if (this.options.getMetricsOptions() != null && this.options.getMetricsOptions().isEnabled() && this.metrics == null) {
            log.warn("Metrics options are configured but no metrics object is instantiated. Make sure you have the VertxMetricsFactory in your classpath and META-INF/services/io.vertx.core.spi.VertxServiceProvider contains the factory FQCN, or metricsOptions.getFactory() returns a non null value");
        }
    }

    public static Transport nativeTransport() {
        Transport transport = null;
        try {
            EpollTransport epoll = new EpollTransport();
            if (epoll.isAvailable()) {
                return epoll;
            }
            transport = epoll;
        }
        catch (Throwable epoll) {
            // empty catch block
        }
        try {
            KQueueTransport kqueue = new KQueueTransport();
            if (kqueue.isAvailable()) {
                return kqueue;
            }
            if (transport == null) {
                transport = kqueue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return transport;
    }

    static Transport findTransport(boolean preferNative) {
        if (preferNative) {
            Collection<Transport> transports = ServiceHelper.loadFactories(Transport.class);
            for (Transport transport : transports) {
                if (!transport.isAvailable()) continue;
                return transport;
            }
            Transport nativeTransport = VertxBuilder.nativeTransport();
            if (nativeTransport != null && nativeTransport.isAvailable()) {
                return nativeTransport;
            }
            return JDKTransport.INSTANCE;
        }
        return JDKTransport.INSTANCE;
    }
}

