/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import com.google.common.collect.EvictingQueue;
import com.google.common.util.concurrent.RateLimiter;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.functions.instance.stats.ComponentStatsManager;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.InstanceCommunication;

public class SourceStatsManager
extends ComponentStatsManager {
    public static final String PULSAR_SOURCE_METRICS_PREFIX = "pulsar_source_";
    public static final String SYSTEM_EXCEPTIONS_TOTAL = "system_exceptions_total";
    public static final String SOURCE_EXCEPTIONS_TOTAL = "source_exceptions_total";
    public static final String LAST_INVOCATION = "last_invocation";
    public static final String RECEIVED_TOTAL = "received_total";
    public static final String WRITTEN_TOTAL = "written_total";
    public static final String SYSTEM_EXCEPTIONS_TOTAL_1min = "system_exceptions_1min";
    public static final String SOURCE_EXCEPTIONS_TOTAL_1min = "source_exceptions_1min";
    public static final String RECEIVED_TOTAL_1min = "received_1min";
    public static final String WRITTEN_TOTAL_1min = "written_1min";
    private final Counter statTotalRecordsReceived;
    private final Counter statTotalSysExceptions;
    private final Counter statTotalSourceExceptions;
    private final Counter statTotalWritten;
    private final Gauge statlastInvocation;
    private final Counter statTotalRecordsReceived1min;
    private final Counter statTotalSysExceptions1min;
    private final Counter statTotalSourceExceptions1min;
    private final Counter statTotalWritten1min;
    final Gauge sysExceptions;
    final Gauge sourceExceptions;
    private final Counter.Child statTotalRecordsReceivedChild;
    private final Counter.Child statTotalSysExceptionsChild;
    private final Counter.Child statTotalSourceExceptionsChild;
    private final Counter.Child statTotalWrittenChild;
    private final Gauge.Child statlastInvocationChild;
    private Counter.Child statTotalRecordsReceivedChild1min;
    private Counter.Child statTotalSysExceptions1minChild;
    private Counter.Child statTotalSourceExceptionsChild1min;
    private Counter.Child statTotalWrittenChild1min;
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions = EvictingQueue.create((int)10);
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSourceExceptions = EvictingQueue.create((int)10);
    protected final RateLimiter sysExceptionRateLimiter;
    protected final RateLimiter sourceExceptionRateLimiter;

    public SourceStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        super(collectorRegistry, metricsLabels, scheduledExecutorService);
        this.statTotalRecordsReceived = collectorRegistry.registerIfNotExist("pulsar_source_received_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_total")).help("Total number of records received from source.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalRecordsReceivedChild = (Counter.Child)this.statTotalRecordsReceived.labels(metricsLabels);
        this.statTotalSysExceptions = collectorRegistry.registerIfNotExist("pulsar_source_system_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_total")).help("Total number of system exceptions.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSysExceptionsChild = (Counter.Child)this.statTotalSysExceptions.labels(metricsLabels);
        this.statTotalSourceExceptions = collectorRegistry.registerIfNotExist("pulsar_source_source_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_total")).help("Total number of source exceptions.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSourceExceptionsChild = (Counter.Child)this.statTotalSourceExceptions.labels(metricsLabels);
        this.statTotalWritten = collectorRegistry.registerIfNotExist("pulsar_source_written_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_total")).help("Total number of records written to a Pulsar topic.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalWrittenChild = (Counter.Child)this.statTotalWritten.labels(metricsLabels);
        this.statlastInvocation = collectorRegistry.registerIfNotExist("pulsar_source_last_invocation", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_last_invocation")).help("The timestamp of the last invocation of the source.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statlastInvocationChild = (Gauge.Child)this.statlastInvocation.labels(metricsLabels);
        this.statTotalRecordsReceived1min = collectorRegistry.registerIfNotExist("pulsar_source_received_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_1min")).help("Total number of records received from source in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalRecordsReceivedChild1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(metricsLabels);
        this.statTotalSysExceptions1min = collectorRegistry.registerIfNotExist("pulsar_source_system_exceptions_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_1min")).help("Total number of system exceptions in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSysExceptions1minChild = (Counter.Child)this.statTotalSysExceptions1min.labels(metricsLabels);
        this.statTotalSourceExceptions1min = collectorRegistry.registerIfNotExist("pulsar_source_source_exceptions_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_1min")).help("Total number of source exceptions in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalSourceExceptionsChild1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(metricsLabels);
        this.statTotalWritten1min = collectorRegistry.registerIfNotExist("pulsar_source_written_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_1min")).help("Total number of records written to a Pulsar topic in the last 1 minute.")).labelNames(METRICS_LABEL_NAMES)).create());
        this.statTotalWrittenChild1min = (Counter.Child)this.statTotalWritten1min.labels(metricsLabels);
        this.sysExceptions = collectorRegistry.registerIfNotExist("pulsar_source_system_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_system_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from system code.")).create());
        this.sourceExceptions = collectorRegistry.registerIfNotExist("pulsar_source_source_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_source_exception")).labelNames(EXCEPTION_METRICS_LABEL_NAMES)).help("Exception from source.")).create());
        this.sysExceptionRateLimiter = RateLimiter.create((double)0.08333333333333333);
        this.sourceExceptionRateLimiter = RateLimiter.create((double)0.08333333333333333);
    }

    @Override
    public void reset() {
        this.statTotalRecordsReceived1min.clear();
        this.statTotalRecordsReceivedChild1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(this.metricsLabels);
        this.statTotalSysExceptions1min.clear();
        this.statTotalSysExceptions1minChild = (Counter.Child)this.statTotalSysExceptions1min.labels(this.metricsLabels);
        this.statTotalSourceExceptions1min.clear();
        this.statTotalSourceExceptionsChild1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(this.metricsLabels);
        this.statTotalWritten1min.clear();
        this.statTotalWrittenChild1min = (Counter.Child)this.statTotalWritten1min.labels(this.metricsLabels);
    }

    @Override
    public void incrTotalReceived() {
        this.statTotalRecordsReceivedChild.inc();
        this.statTotalRecordsReceivedChild1min.inc();
    }

    @Override
    public void incrTotalProcessedSuccessfully() {
        this.statTotalWrittenChild.inc();
        this.statTotalWrittenChild1min.inc();
    }

    @Override
    public void incrSysExceptions(Throwable ex) {
        this.statTotalSysExceptionsChild.inc();
        this.statTotalSysExceptions1minChild.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSystemExceptions.add((Object)info);
        if (this.sysExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sysExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    @Override
    public void incrUserExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSourceExceptions(Throwable ex) {
        this.statTotalSourceExceptionsChild.inc();
        this.statTotalSourceExceptionsChild1min.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSourceExceptions.add((Object)info);
        if (this.sourceExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sourceExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    private String[] getExceptionMetricsLabels(Throwable ex) {
        String[] exceptionMetricsLabels = Arrays.copyOf(this.metricsLabels, this.metricsLabels.length + 1);
        exceptionMetricsLabels[exceptionMetricsLabels.length - 1] = ex.getMessage() != null ? ex.getMessage() : "";
        return exceptionMetricsLabels;
    }

    @Override
    public void incrSinkExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void setLastInvocation(long ts) {
        this.statlastInvocationChild.set((double)ts);
    }

    @Override
    public void processTimeEnd(long startTime) {
    }

    @Override
    public double getTotalProcessedSuccessfully() {
        return this.statTotalWrittenChild.get();
    }

    @Override
    public double getTotalRecordsReceived() {
        return this.statTotalRecordsReceivedChild.get();
    }

    @Override
    public double getTotalSysExceptions() {
        return this.statTotalSysExceptionsChild.get();
    }

    @Override
    public double getTotalUserExceptions() {
        return 0.0;
    }

    @Override
    public double getLastInvocation() {
        return this.statlastInvocationChild.get();
    }

    @Override
    public double getAvgProcessLatency() {
        return 0.0;
    }

    @Override
    public double getTotalProcessedSuccessfully1min() {
        return this.statTotalWrittenChild1min.get();
    }

    @Override
    public double getTotalRecordsReceived1min() {
        return this.statTotalRecordsReceivedChild1min.get();
    }

    @Override
    public double getTotalSysExceptions1min() {
        return this.statTotalSysExceptions1minChild.get();
    }

    @Override
    public double getTotalUserExceptions1min() {
        return 0.0;
    }

    @Override
    public double getAvgProcessLatency1min() {
        return 0.0;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions() {
        return EvictingQueue.create((int)0);
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions() {
        return this.latestSystemExceptions;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions() {
        return this.latestSourceExceptions;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions() {
        return EvictingQueue.create((int)0);
    }
}

