/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;

@VertxGen
public interface UserContext {
    public @Nullable User get();

    default public boolean authenticated() {
        return this.get() != null;
    }

    @Fluent
    public UserContext loginHint(String var1);

    public Future<Void> impersonate();

    default public void impersonate(Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.impersonate();
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public Future<Void> impersonate(String var1);

    default public void impersonate(String redirectUri, Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.impersonate(redirectUri);
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public Future<Void> restore();

    default public void restore(Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.restore();
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public Future<Void> restore(String var1);

    default public void restore(String redirectUri, Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.restore(redirectUri);
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public Future<Void> logout(String var1);

    default public void logout(String redirectUri, Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.logout(redirectUri);
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public Future<Void> logout();

    default public void logout(Handler<AsyncResult<Void>> callback) {
        Future<Void> fut = this.logout();
        if (callback != null) {
            fut.onComplete(callback);
        }
    }

    public void clear();
}

