/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.proto.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarFunctionRecord<T>
implements Record<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionRecord.class);
    private final Record<T> record;
    private final Function.FunctionDetails functionConfig;

    public PulsarFunctionRecord(Record<T> record, Function.FunctionDetails functionConfig) {
        this.record = record;
        this.functionConfig = functionConfig;
    }

    public Optional<String> getTopicName() {
        return this.record.getTopicName();
    }

    public Optional<String> getKey() {
        return this.record.getKey();
    }

    public Schema getSchema() {
        return this.record.getSchema();
    }

    public T getValue() {
        return (T)this.record.getValue();
    }

    public Optional<Long> getEventTime() {
        return this.record.getEventTime();
    }

    public Optional<String> getPartitionId() {
        return this.record.getPartitionId();
    }

    public Optional<Integer> getPartitionIndex() {
        return this.record.getPartitionIndex();
    }

    public Optional<Long> getRecordSequence() {
        return this.record.getRecordSequence();
    }

    public Map<String, String> getProperties() {
        return this.record.getProperties();
    }

    public void ack() {
        Function.ProcessingGuarantees processingGuarantees = this.functionConfig.getProcessingGuarantees();
        if (processingGuarantees == Function.ProcessingGuarantees.MANUAL) {
            this.record.ack();
        } else {
            log.warn("Ignore this ack option, under this configuration Guarantees:[{}] autoAck:[{}], the framework will automatically ack", (Object)processingGuarantees, (Object)this.functionConfig.getAutoAck());
        }
    }

    public void fail() {
        this.record.fail();
    }

    public Optional<String> getDestinationTopic() {
        return this.record.getDestinationTopic();
    }

    public Optional<Message<T>> getMessage() {
        return this.record.getMessage();
    }
}

