/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.pulsar.broker.service.Consumer;

public class PendingAcksMap {
    private final Consumer consumer;
    private final Long2ObjectSortedMap<Long2ObjectSortedMap<IntIntPair>> pendingAcks;
    private final Supplier<PendingAcksAddHandler> pendingAcksAddHandlerSupplier;
    private final Supplier<PendingAcksRemoveHandler> pendingAcksRemoveHandlerSupplier;
    private final Lock readLock;
    private final Lock writeLock;
    private boolean closed = false;

    PendingAcksMap(Consumer consumer, Supplier<PendingAcksAddHandler> pendingAcksAddHandlerSupplier, Supplier<PendingAcksRemoveHandler> pendingAcksRemoveHandlerSupplier) {
        this.consumer = consumer;
        this.pendingAcks = new Long2ObjectRBTreeMap();
        this.pendingAcksAddHandlerSupplier = pendingAcksAddHandlerSupplier;
        this.pendingAcksRemoveHandlerSupplier = pendingAcksRemoveHandlerSupplier;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.writeLock = readWriteLock.writeLock();
        this.readLock = readWriteLock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPendingAckIfAllowed(long ledgerId, long entryId, int batchSize, int stickyKeyHash) {
        try {
            this.writeLock.lock();
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            PendingAcksAddHandler pendingAcksAddHandler = this.pendingAcksAddHandlerSupplier.get();
            if (pendingAcksAddHandler != null && !pendingAcksAddHandler.handleAdding(this.consumer, ledgerId, entryId, stickyKeyHash)) {
                boolean bl = false;
                return bl;
            }
            Long2ObjectSortedMap ledgerPendingAcks = (Long2ObjectSortedMap)this.pendingAcks.computeIfAbsent(ledgerId, k -> new Long2ObjectRBTreeMap());
            ledgerPendingAcks.put(entryId, (Object)IntIntPair.of((int)batchSize, (int)stickyKeyHash));
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long size() {
        try {
            this.readLock.lock();
            long l = this.pendingAcks.values().stream().mapToInt(Long2ObjectMap::size).sum();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void forEach(PendingAcksConsumer processor) {
        try {
            this.readLock.lock();
            this.processPendingAcks(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void processPendingAcks(PendingAcksConsumer processor) {
        for (Map.Entry entry : this.pendingAcks.entrySet()) {
            Long ledgerId = (Long)entry.getKey();
            Long2ObjectSortedMap ledgerPendingAcks = (Long2ObjectSortedMap)entry.getValue();
            for (Map.Entry e : ledgerPendingAcks.entrySet()) {
                Long entryId = (Long)e.getKey();
                IntIntPair batchSizeAndStickyKeyHash = (IntIntPair)e.getValue();
                processor.accept(ledgerId, entryId, batchSizeAndStickyKeyHash.leftInt(), batchSizeAndStickyKeyHash.rightInt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachAndClose(PendingAcksConsumer processor) {
        try {
            this.writeLock.lock();
            this.closed = true;
            PendingAcksRemoveHandler pendingAcksRemoveHandler = this.pendingAcksRemoveHandlerSupplier.get();
            if (pendingAcksRemoveHandler != null) {
                try {
                    pendingAcksRemoveHandler.startBatch();
                    this.processPendingAcks((ledgerId, entryId, batchSize, stickyKeyHash) -> {
                        processor.accept(ledgerId, entryId, batchSize, stickyKeyHash);
                        pendingAcksRemoveHandler.handleRemoving(this.consumer, ledgerId, entryId, stickyKeyHash, this.closed);
                    });
                }
                finally {
                    pendingAcksRemoveHandler.endBatch();
                }
            } else {
                this.processPendingAcks(processor);
            }
            this.pendingAcks.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long ledgerId, long entryId) {
        try {
            this.readLock.lock();
            Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)this.pendingAcks.get(ledgerId);
            if (ledgerMap == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ledgerMap.containsKey(entryId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntIntPair get(long ledgerId, long entryId) {
        try {
            this.readLock.lock();
            Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)this.pendingAcks.get(ledgerId);
            if (ledgerMap == null) {
                IntIntPair intIntPair = null;
                return intIntPair;
            }
            IntIntPair intIntPair = (IntIntPair)ledgerMap.get(entryId);
            return intIntPair;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long ledgerId, long entryId, int batchSize, int stickyKeyHash) {
        try {
            this.writeLock.lock();
            Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)this.pendingAcks.get(ledgerId);
            if (ledgerMap == null) {
                boolean bl = false;
                return bl;
            }
            boolean removed = ledgerMap.remove(entryId, (Object)IntIntPair.of((int)batchSize, (int)stickyKeyHash));
            if (removed) {
                this.handleRemovePendingAck(ledgerId, entryId, stickyKeyHash);
            }
            if (removed && ledgerMap.isEmpty()) {
                this.pendingAcks.remove(ledgerId);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long ledgerId, long entryId) {
        try {
            boolean removed;
            this.writeLock.lock();
            Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)this.pendingAcks.get(ledgerId);
            if (ledgerMap == null) {
                boolean bl = false;
                return bl;
            }
            IntIntPair removedEntry = (IntIntPair)ledgerMap.remove(entryId);
            boolean bl = removed = removedEntry != null;
            if (removed) {
                int stickyKeyHash = removedEntry.rightInt();
                this.handleRemovePendingAck(ledgerId, entryId, stickyKeyHash);
            }
            if (removed && ledgerMap.isEmpty()) {
                this.pendingAcks.remove(ledgerId);
            }
            boolean bl2 = removed;
            return bl2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeAllUpTo(long markDeleteLedgerId, long markDeleteEntryId) {
        this.internalRemoveAllUpTo(markDeleteLedgerId, markDeleteEntryId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveAllUpTo(long markDeleteLedgerId, long markDeleteEntryId, boolean useWriteLock) {
        PendingAcksRemoveHandler pendingAcksRemoveHandler = this.pendingAcksRemoveHandlerSupplier.get();
        boolean acquiredWriteLock = false;
        boolean batchStarted = false;
        boolean retryWithWriteLock = false;
        try {
            if (useWriteLock) {
                this.writeLock.lock();
                acquiredWriteLock = true;
            } else {
                this.readLock.lock();
            }
            ObjectBidirectionalIterator ledgerMapIterator = this.pendingAcks.headMap(markDeleteLedgerId + 1L).long2ObjectEntrySet().iterator();
            while (ledgerMapIterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)ledgerMapIterator.next();
                long ledgerId = entry.getLongKey();
                Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)entry.getValue();
                Long2ObjectSortedMap ledgerMapHead = ledgerId == markDeleteLedgerId ? ledgerMap.headMap(markDeleteEntryId + 1L) : ledgerMap;
                ObjectBidirectionalIterator entryMapIterator = ledgerMapHead.long2ObjectEntrySet().iterator();
                while (entryMapIterator.hasNext()) {
                    Long2ObjectMap.Entry intIntPairEntry = (Long2ObjectMap.Entry)entryMapIterator.next();
                    long entryId = intIntPairEntry.getLongKey();
                    if (!acquiredWriteLock) {
                        retryWithWriteLock = true;
                        return;
                    }
                    if (pendingAcksRemoveHandler != null) {
                        if (!batchStarted) {
                            pendingAcksRemoveHandler.startBatch();
                            batchStarted = true;
                        }
                        int stickyKeyHash = ((IntIntPair)intIntPairEntry.getValue()).rightInt();
                        pendingAcksRemoveHandler.handleRemoving(this.consumer, ledgerId, entryId, stickyKeyHash, this.closed);
                    }
                    entryMapIterator.remove();
                }
                if (!ledgerMap.isEmpty()) continue;
                if (!acquiredWriteLock) {
                    retryWithWriteLock = true;
                    return;
                }
                ledgerMapIterator.remove();
            }
        }
        finally {
            if (batchStarted) {
                pendingAcksRemoveHandler.endBatch();
            }
            if (acquiredWriteLock) {
                this.writeLock.unlock();
            } else {
                this.readLock.unlock();
                if (retryWithWriteLock) {
                    this.internalRemoveAllUpTo(markDeleteLedgerId, markDeleteEntryId, true);
                }
            }
        }
    }

    private void handleRemovePendingAck(long ledgerId, long entryId, int stickyKeyHash) {
        PendingAcksRemoveHandler pendingAcksRemoveHandler = this.pendingAcksRemoveHandlerSupplier.get();
        if (pendingAcksRemoveHandler != null) {
            pendingAcksRemoveHandler.handleRemoving(this.consumer, ledgerId, entryId, stickyKeyHash, this.closed);
        }
    }

    public static interface PendingAcksAddHandler {
        public boolean handleAdding(Consumer var1, long var2, long var4, int var6);
    }

    public static interface PendingAcksConsumer {
        public void accept(long var1, long var3, int var5, int var6);
    }

    public static interface PendingAcksRemoveHandler {
        public void handleRemoving(Consumer var1, long var2, long var4, int var6, boolean var7);

        public void startBatch();

        public void endBatch();
    }
}

