/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.fasterxml.jackson.databind.ObjectReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.loadbalance.LoadReport;
import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.ServiceRequest;
import org.apache.pulsar.broker.loadbalance.ServiceUnit;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarLoadReportImpl
implements LoadReport {
    private static final Logger log = LoggerFactory.getLogger(PulsarLoadReportImpl.class);
    public Map<ServiceUnit, ServiceRequest> requestPerServiceUnit = new HashMap<ServiceUnit, ServiceRequest>();
    private SimpleResourceUnit resourceUnit = null;
    private PulsarResourceDescription resourceDescription = null;
    private static final ObjectReader LOAD_REPORT_READER = ObjectMapperFactory.getMapper().reader().forType(org.apache.pulsar.policies.data.loadbalancer.LoadReport.class);

    private PulsarLoadReportImpl() {
    }

    @Override
    public Map<ServiceUnit, ServiceRequest> getServiceUnitRequests() {
        return this.requestPerServiceUnit;
    }

    public static LoadReport parse(String loadReportJson) {
        PulsarLoadReportImpl pulsarLoadReport = new PulsarLoadReportImpl();
        try {
            org.apache.pulsar.policies.data.loadbalancer.LoadReport report = (org.apache.pulsar.policies.data.loadbalancer.LoadReport)LOAD_REPORT_READER.readValue(loadReportJson);
            SystemResourceUsage sru = report.getSystemResourceUsage();
            String resourceUnitName = report.getName();
            pulsarLoadReport.resourceDescription = new PulsarResourceDescription();
            if (sru.bandwidthIn != null) {
                pulsarLoadReport.resourceDescription.put("bandwidthIn", sru.bandwidthIn);
            }
            if (sru.bandwidthOut != null) {
                pulsarLoadReport.resourceDescription.put("bandwidthOut", sru.bandwidthOut);
            }
            if (sru.memory != null) {
                pulsarLoadReport.resourceDescription.put("memory", sru.memory);
            }
            if (sru.cpu != null) {
                pulsarLoadReport.resourceDescription.put("cpu", sru.cpu);
            }
            pulsarLoadReport.resourceUnit = new SimpleResourceUnit(resourceUnitName, pulsarLoadReport.resourceDescription);
        }
        catch (Exception e) {
            log.warn("Failed Parsing Load Report from JSON string", (Throwable)e);
        }
        return pulsarLoadReport;
    }

    @Override
    public ResourceUnit getResourceUnit() {
        return this.resourceUnit;
    }

    @Override
    public ResourceDescription getResourceUnitDescription() {
        return this.resourceDescription;
    }
}

