/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.common.policies.data.stats.TopicMetricBean;

public class BucketDelayedMessageIndexStats {
    private static final long[] BUCKETS = new long[]{50L, 100L, 500L, 1000L, 5000L, 30000L, 60000L};
    private static final String BUCKET_TOTAL_NAME = "pulsar_delayed_message_index_bucket_total";
    private static final String INDEX_LOADED_NAME = "pulsar_delayed_message_index_loaded";
    private static final String SNAPSHOT_SIZE_BYTES_NAME = "pulsar_delayed_message_index_bucket_snapshot_size_bytes";
    private static final String OP_COUNT_NAME = "pulsar_delayed_message_index_bucket_op_count";
    private static final String OP_LATENCY_NAME = "pulsar_delayed_message_index_bucket_op_latency_ms";
    private final AtomicInteger delayedMessageIndexBucketTotal = new AtomicInteger();
    private final AtomicLong delayedMessageIndexLoaded = new AtomicLong();
    private final AtomicLong delayedMessageIndexBucketSnapshotSizeBytes = new AtomicLong();
    private final Map<String, StatsBuckets> delayedMessageIndexBucketOpLatencyMs = new ConcurrentHashMap<String, StatsBuckets>();
    private final Map<String, LongAdder> delayedMessageIndexBucketOpCount = new ConcurrentHashMap<String, LongAdder>();

    public Map<String, TopicMetricBean> genTopicMetricMap() {
        HashMap<String, TopicMetricBean> metrics = new HashMap<String, TopicMetricBean>();
        metrics.put(BUCKET_TOTAL_NAME, new TopicMetricBean(BUCKET_TOTAL_NAME, (double)this.delayedMessageIndexBucketTotal.get(), null));
        metrics.put(INDEX_LOADED_NAME, new TopicMetricBean(INDEX_LOADED_NAME, (double)this.delayedMessageIndexLoaded.get(), null));
        metrics.put(SNAPSHOT_SIZE_BYTES_NAME, new TopicMetricBean(SNAPSHOT_SIZE_BYTES_NAME, (double)this.delayedMessageIndexBucketSnapshotSizeBytes.get(), null));
        this.delayedMessageIndexBucketOpCount.forEach((k, count) -> {
            String[] labels = BucketDelayedMessageIndexStats.splitKey(k);
            String[] labelsAndValues = new String[]{"state", labels[0], "type", labels[1]};
            String key = OP_COUNT_NAME + BucketDelayedMessageIndexStats.joinKey(labelsAndValues);
            metrics.put(key, new TopicMetricBean(OP_COUNT_NAME, (double)count.sumThenReset(), labelsAndValues));
        });
        this.delayedMessageIndexBucketOpLatencyMs.forEach((typeName, statsBuckets) -> {
            statsBuckets.refresh();
            long[] buckets = statsBuckets.getBuckets();
            for (int i = 0; i < buckets.length; ++i) {
                long count = buckets[i];
                if (count == 0L) continue;
                String quantile = i == BUCKETS.length ? "overflow" : String.valueOf(BUCKETS[i]);
                String[] labelsAndValues = new String[]{"type", typeName, "quantile", quantile};
                String key = OP_LATENCY_NAME + BucketDelayedMessageIndexStats.joinKey(labelsAndValues);
                metrics.put(key, new TopicMetricBean(OP_LATENCY_NAME, (double)count, labelsAndValues));
            }
            String[] labelsAndValues = new String[]{"type", typeName};
            metrics.put("pulsar_delayed_message_index_bucket_op_latency_ms_count" + BucketDelayedMessageIndexStats.joinKey(labelsAndValues), new TopicMetricBean("pulsar_delayed_message_index_bucket_op_latency_ms_count", (double)statsBuckets.getCount(), labelsAndValues));
            metrics.put("pulsar_delayed_message_index_bucket_op_latency_ms_sum" + BucketDelayedMessageIndexStats.joinKey(labelsAndValues), new TopicMetricBean("pulsar_delayed_message_index_bucket_op_latency_ms_sum", (double)statsBuckets.getSum(), labelsAndValues));
        });
        return metrics;
    }

    public void recordNumOfBuckets(int numOfBuckets) {
        this.delayedMessageIndexBucketTotal.set(numOfBuckets);
    }

    public void recordDelayedMessageIndexLoaded(long num) {
        this.delayedMessageIndexLoaded.set(num);
    }

    public void recordBucketSnapshotSizeBytes(long sizeBytes) {
        this.delayedMessageIndexBucketSnapshotSizeBytes.set(sizeBytes);
    }

    public void recordTriggerEvent(Type eventType) {
        this.delayedMessageIndexBucketOpCount.computeIfAbsent(BucketDelayedMessageIndexStats.joinKey(State.all.name(), eventType.name()), k -> new LongAdder()).increment();
    }

    public void recordSuccessEvent(Type eventType, long cost) {
        this.delayedMessageIndexBucketOpCount.computeIfAbsent(BucketDelayedMessageIndexStats.joinKey(State.succeed.name(), eventType.name()), k -> new LongAdder()).increment();
        this.delayedMessageIndexBucketOpLatencyMs.computeIfAbsent(eventType.name(), k -> new StatsBuckets(BUCKETS)).addValue(cost);
    }

    public void recordFailEvent(Type eventType) {
        this.delayedMessageIndexBucketOpCount.computeIfAbsent(BucketDelayedMessageIndexStats.joinKey(State.failed.name(), eventType.name()), k -> new LongAdder()).increment();
    }

    public static String joinKey(String ... values) {
        return String.join((CharSequence)"_", values);
    }

    public static String[] splitKey(String key) {
        return key.split("_");
    }

    static enum State {
        succeed,
        failed,
        all;

    }

    static enum Type {
        create,
        load,
        delete,
        merge;

    }
}

