/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) since 2016 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.connectors.google.firebase.fcm

import org.apache.pekko.stream.connectors.google.firebase.fcm.FcmNotificationModels._

/** Use class from package org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models */
@deprecated("Use class from package org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models", "Alpakka 3.0.2")
@Deprecated
object FcmNotificationModels {

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.BasicNotification */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.BasicNotification", "Alpakka 3.0.2")
  @Deprecated
  case class BasicNotification(title: String, body: String)

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidNotification */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidNotification",
    "Alpakka 3.0.2")
  @Deprecated
  case class AndroidNotification(
      title: String,
      body: String,
      icon: String,
      color: String,
      sound: String,
      tag: String,
      click_action: String,
      body_loc_key: String,
      body_loc_args: Seq[String],
      title_loc_key: String,
      title_loc_args: Seq[String])

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidConfig */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidConfig", "Alpakka 3.0.2")
  @Deprecated
  case class AndroidConfig(
      collapse_key: String,
      priority: AndroidMessagePriority,
      ttl: String,
      restricted_package_name: String,
      data: Map[String, String],
      notification: AndroidNotification)

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidMessagePriority */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.AndroidMessagePriority",
    "Alpakka 3.0.2")
  @Deprecated
  sealed trait AndroidMessagePriority

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Normal */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Normal", "Alpakka 3.0.2")
  @Deprecated
  case object Normal extends AndroidMessagePriority

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.High */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.High", "Alpakka 3.0.2")
  @Deprecated
  case object High extends AndroidMessagePriority

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.WebPushConfig */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.WebPushConfig", "Alpakka 3.0.2")
  @Deprecated
  case class WebPushNotification(title: String, body: String, icon: String)

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.WebPushConfig */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.WebPushConfig", "Alpakka 3.0.2")
  @Deprecated
  case class WebPushConfig(headers: Map[String, String], data: Map[String, String], notification: WebPushNotification)

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.ApnsConfig */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.ApnsConfig", "Alpakka 3.0.2")
  @Deprecated
  case class ApnsConfig(headers: Map[String, String], rawPayload: String)

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.NotificationTarget */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.NotificationTarget",
    "Alpakka 3.0.2")
  @Deprecated
  sealed trait NotificationTarget

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Token */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Token", "Alpakka 3.0.2")
  @Deprecated
  case class Token(token: String) extends NotificationTarget

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Topic */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Topic", "Alpakka 3.0.2")
  @Deprecated
  case class Topic(topic: String) extends NotificationTarget

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Condition */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Condition", "Alpakka 3.0.2")
  @Deprecated
  case class Condition(conditionText: String) extends NotificationTarget

  /** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Condition */
  @deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.Condition", "Alpakka 3.0.2")
  @Deprecated
  object Condition {
    sealed trait ConditionBuilder {
      def &&(condition: ConditionBuilder) = And(this, condition)
      def ||(condition: ConditionBuilder) = Or(this, condition)
      def unary_! = Not(this)
      def toConditionText: String
    }
    case class Topic(topic: String) extends ConditionBuilder {
      def toConditionText: String = s"'$topic' in topics"
    }
    case class And(condition1: ConditionBuilder, condition2: ConditionBuilder) extends ConditionBuilder {
      def toConditionText: String = s"(${condition1.toConditionText} && ${condition2.toConditionText})"
    }
    case class Or(condition1: ConditionBuilder, condition2: ConditionBuilder) extends ConditionBuilder {
      def toConditionText: String = s"(${condition1.toConditionText} || ${condition2.toConditionText})"
    }
    case class Not(condition: ConditionBuilder) extends ConditionBuilder {
      def toConditionText: String = s"!(${condition.toConditionText})"
    }

    def apply(builder: ConditionBuilder): Condition =
      Condition(builder.toConditionText)
  }
}

/** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmNotification */
@deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmNotification", "Alpakka 3.0.2")
@Deprecated
case class FcmNotification(
    data: Option[Map[String, String]] = None,
    notification: Option[BasicNotification] = None,
    android: Option[AndroidConfig] = None,
    webPush: Option[WebPushConfig] = None,
    apns: Option[ApnsConfig] = None,
    token: Option[String] = None,
    topic: Option[String] = None,
    condition: Option[String] = None) {
  def withData(data: Map[String, String]): FcmNotification = this.copy(data = Option(data))
  def withBasicNotification(notification: BasicNotification): FcmNotification =
    this.copy(notification = Option(notification))
  def withBasicNotification(title: String, body: String): FcmNotification =
    this.copy(notification = Option(BasicNotification(title, body)))
  def withAndroidConfig(android: AndroidConfig): FcmNotification = this.copy(android = Option(android))
  def withWebPushConfig(webPush: WebPushConfig): FcmNotification = this.copy(webPush = Option(webPush))
  def withApnsConfig(apns: ApnsConfig): FcmNotification = this.copy(apns = Option(apns))
  def withTarget(target: NotificationTarget): FcmNotification = target match {
    case Token(t)     => this.copy(token = Option(t), topic = None, condition = None)
    case Topic(t)     => this.copy(token = None, topic = Option(t), condition = None)
    case Condition(t) => this.copy(token = None, topic = None, condition = Option(t))
  }
  def isSendable: Boolean =
    (token.isDefined ^ topic.isDefined ^ condition.isDefined) && !(token.isDefined && topic.isDefined)
}

/** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmNotification */
@deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmNotification", "Alpakka 3.0.2")
@Deprecated
object FcmNotification {
  val empty: FcmNotification = FcmNotification()
  def fromJava(): FcmNotification = empty
  def apply(notification: BasicNotification, target: NotificationTarget): FcmNotification =
    empty.withBasicNotification(notification).withTarget(target)
  def apply(title: String, body: String, target: NotificationTarget): FcmNotification =
    empty.withBasicNotification(title, body).withTarget(target)
  def basic(title: String, body: String, target: NotificationTarget) = FcmNotification(title, body, target)
}

/** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmResponse */
@deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmResponse", "Alpakka 3.0.2")
@Deprecated
sealed trait FcmResponse {
  def isFailure: Boolean
  def isSuccess: Boolean
}

/** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmSuccessResponse */
@deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmSuccessResponse", "Alpakka 3.0.2")
@Deprecated
final case class FcmSuccessResponse(name: String) extends FcmResponse {
  val isFailure = false
  val isSuccess = true
  def getName: String = name
}

/** Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmErrorResponse */
@deprecated("Use org.apache.pekko.stream.connectors.google.firebase.fcm.v1.models.FcmErrorResponse", "Alpakka 3.0.2")
@Deprecated
final case class FcmErrorResponse(rawError: String) extends FcmResponse {
  val isFailure = true
  val isSuccess = false
  def getRawError: String = rawError
}
