/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.normalizer;

import java.util.regex.Pattern;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class TwitterCharSequenceNormalizer
implements CharSequenceNormalizer {
    private static final long serialVersionUID = -8155452559337913929L;
    private static final Pattern HASH_USER_REGEX = Pattern.compile("[#@]\\S+");
    private static final Pattern RT_REGEX = Pattern.compile("\\b(rt[ :])+", 2);
    private static final Pattern FACE_REGEX = Pattern.compile("[:;x]-?[()dop]", 2);
    private static final Pattern LAUGH_REGEX = Pattern.compile("([hj])+([aieou])+(\\1+\\2+)+", 2);
    private static final TwitterCharSequenceNormalizer INSTANCE = new TwitterCharSequenceNormalizer();

    public static TwitterCharSequenceNormalizer getInstance() {
        return INSTANCE;
    }

    public CharSequence normalize(CharSequence text) {
        String modified = HASH_USER_REGEX.matcher(text).replaceAll(" ");
        modified = RT_REGEX.matcher(modified).replaceAll(" ");
        modified = FACE_REGEX.matcher(modified).replaceAll(" ");
        modified = LAUGH_REGEX.matcher(modified).replaceAll("$1$2$1$2");
        return modified;
    }
}

