/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.log;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import org.apache.openmeetings.db.entity.log.ConferenceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ConferenceLogDao {
    private static final Logger log = LoggerFactory.getLogger(ConferenceLogDao.class);
    @PersistenceContext
    private EntityManager em;

    public ConferenceLog add(ConferenceLog.Type type, Long userId, String streamid, Long roomId, String userip, String scopeName) {
        ConferenceLog confLog = new ConferenceLog();
        confLog.setType(type);
        confLog.setInserted(new Date());
        confLog.setUserId(userId);
        confLog.setStreamid(streamid);
        confLog.setScopeName(scopeName);
        confLog.setRoomId(roomId);
        confLog.setUserip(userip);
        this.em.persist((Object)confLog);
        log.debug("[add]: {}", (Object)confLog);
        return confLog;
    }

    public int clear(long ttl) {
        return this.em.createNamedQuery("clearLogUserIp").setParameter("date", (Object)new Date(System.currentTimeMillis() - ttl)).executeUpdate();
    }
}

