/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.handler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.CalendarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCalendarHandler
implements CalendarHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractCalendarHandler.class);
    protected HttpClient client;
    protected HttpClientContext context;
    protected OmCalendar calendar;
    protected String path;
    protected IcalUtils utils;
    protected AppointmentDao appointmentDao;

    protected AbstractCalendarHandler(String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        this.path = path;
        this.calendar = calendar;
        this.client = client;
        this.context = context;
        this.appointmentDao = appointmentDao;
        this.utils = utils;
    }

    static Map<String, Appointment> listToMap(List<Appointment> appointments) {
        return appointments.stream().collect(Collectors.toMap(Appointment::getHref, Function.identity()));
    }

    @Override
    public OmCalendar syncItems() {
        BaseDavRequest method = null;
        try {
            method = this.internalSyncItems();
        }
        catch (IOException | DavException e) {
            log.error("Error during the execution of calendar-multiget Report.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Severe Error during the execution of calendar-multiget Report.", (Throwable)e);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        return this.calendar;
    }

    void releaseConnection(HttpRequestBase method) {
        if (method != null) {
            method.reset();
        }
    }

    abstract BaseDavRequest internalSyncItems() throws IOException, DavException;
}

