/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexRegistry;

public class QueryContext {
    protected IndexRegistry indexRegistry;
    protected int ownedPartitionCount = -1;

    public QueryContext(IndexRegistry indexRegistry, int ownedPartitionCount) {
        this.indexRegistry = indexRegistry;
        this.ownedPartitionCount = ownedPartitionCount;
    }

    QueryContext() {
    }

    public int getOwnedPartitionCount() {
        return this.ownedPartitionCount;
    }

    public void setOwnedPartitionCount(int ownedPartitionCount) {
        this.ownedPartitionCount = ownedPartitionCount;
    }

    void attachTo(IndexRegistry indexes, int ownedPartitionCount) {
        this.indexRegistry = indexes;
        this.ownedPartitionCount = ownedPartitionCount;
    }

    void applyPerQueryStats() {
    }

    public Index getIndex(String attribute) {
        return this.matchIndex(attribute, IndexMatchHint.NONE);
    }

    public Index matchIndex(String pattern, IndexMatchHint matchHint) {
        return this.indexRegistry.matchIndex(pattern, matchHint, this.ownedPartitionCount);
    }

    public static enum IndexMatchHint {
        NONE,
        PREFER_UNORDERED,
        PREFER_ORDERED,
        EXACT_NAME;

    }
}

