/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UnmodifiableIterator;
import com.hazelcast.map.impl.MapEntrySimple;
import com.hazelcast.map.impl.MapKeyLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.function.Function;

public final class MapKeyLoaderUtil {
    private MapKeyLoaderUtil() {
    }

    static MapKeyLoader.Role assignRole(boolean isPartitionOwner, boolean isMapNamePartition, boolean isMapNamePartitionFirstReplica) {
        if (isMapNamePartition) {
            if (isPartitionOwner) {
                return MapKeyLoader.Role.SENDER;
            }
            if (isMapNamePartitionFirstReplica) {
                return MapKeyLoader.Role.SENDER_BACKUP;
            }
            return MapKeyLoader.Role.NONE;
        }
        return isPartitionOwner ? MapKeyLoader.Role.RECEIVER : MapKeyLoader.Role.NONE;
    }

    static Iterator<Map<Integer, List<Data>>> toBatches(final Iterator<Map.Entry<Integer, Data>> entries, final int maxBatch, final Semaphore nodeWideLoadedKeyLimiter) {
        return new UnmodifiableIterator<Map<Integer, List<Data>>>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public Map<Integer, List<Data>> next() {
                if (!entries.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MapKeyLoaderUtil.nextBatch(entries, maxBatch, nodeWideLoadedKeyLimiter);
            }
        };
    }

    private static Map<Integer, List<Data>> nextBatch(Iterator<Map.Entry<Integer, Data>> entries, int maxBatch, Semaphore nodeWideLoadedKeyLimiter) {
        Map<Integer, List<Data>> batch = MapUtil.createHashMap(maxBatch);
        while (entries.hasNext() && nodeWideLoadedKeyLimiter.tryAcquire()) {
            Map.Entry<Integer, Data> e = entries.next();
            List partitionKeys = batch.computeIfAbsent(e.getKey(), k -> new ArrayList());
            partitionKeys.add(e.getValue());
            if (partitionKeys.size() < maxBatch) continue;
            break;
        }
        return batch;
    }

    public static int getMaxSizePerNode(EvictionConfig evictionConfig) {
        double maxSizePerNode;
        double d = maxSizePerNode = evictionConfig.getMaxSizePolicy() == MaxSizePolicy.PER_NODE ? (double)evictionConfig.getSize() : -1.0;
        if (maxSizePerNode == 2.147483647E9) {
            return -1;
        }
        return (int)maxSizePerNode;
    }

    static Function<Data, Map.Entry<Integer, Data>> toPartition(IPartitionService partitionService) {
        return new DataToEntry(partitionService);
    }

    private static class DataToEntry
    implements Function<Data, Map.Entry<Integer, Data>> {
        private final IPartitionService partitionService;

        DataToEntry(IPartitionService partitionService) {
            this.partitionService = partitionService;
        }

        @Override
        public Map.Entry<Integer, Data> apply(Data input) {
            Preconditions.checkNotNull(input, "Key loaded by a MapLoader cannot be null.");
            Integer partition = this.partitionService.getPartitionId(input);
            return new MapEntrySimple<Integer, Data>(partition, input);
        }
    }
}

