/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.core.JobSuspensionCause;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JobSuspensionCauseImpl
implements JobSuspensionCause,
IdentifiedDataSerializable {
    private static final JobSuspensionCauseImpl REQUESTED_BY_USER = new JobSuspensionCauseImpl(null);
    private String error;

    public JobSuspensionCauseImpl() {
    }

    private JobSuspensionCauseImpl(String error) {
        this.error = error;
    }

    @Override
    public boolean requestedByUser() {
        return this.error == null;
    }

    @Override
    public boolean dueToError() {
        return this.error != null;
    }

    @Override
    @Nonnull
    public String errorCause() {
        if (this.error == null) {
            throw new IllegalStateException("Suspension not caused by an error");
        }
        return this.error;
    }

    @Override
    @Nonnull
    public String description() {
        return Objects.requireNonNullElse(this.error, "Requested by user");
    }

    public String toString() {
        return this.description();
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 43;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.error);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.error = (String)in.readObject();
    }

    static JobSuspensionCauseImpl causedBy(String cause) {
        return cause == null ? REQUESTED_BY_USER : new JobSuspensionCauseImpl(cause);
    }
}

