/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.cache.EventJournalCacheEvent;
import com.hazelcast.cache.impl.journal.CacheEventJournalFunctions;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.map.EventJournalMapEvent;
import com.hazelcast.map.impl.journal.MapEventJournalFunctions;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Util {
    private static final char[] ID_TEMPLATE = "0000-0000-0000-0000".toCharArray();
    private static final Pattern ID_PATTERN = Pattern.compile("(\\p{XDigit}{4}-){3}\\p{XDigit}{4}");

    private Util() {
    }

    public static <K, V> Map.Entry<K, V> entry(@Nullable K key, @Nullable V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> PredicateEx<EventJournalMapEvent<K, V>> mapPutEvents() {
        return ImdgUtil.wrapImdgPredicate(MapEventJournalFunctions.mapPutEvents());
    }

    public static <K, V> PredicateEx<EventJournalCacheEvent<K, V>> cachePutEvents() {
        return ImdgUtil.wrapImdgPredicate(CacheEventJournalFunctions.cachePutEvents());
    }

    public static <K, V> FunctionEx<EventJournalMapEvent<K, V>, Map.Entry<K, V>> mapEventToEntry() {
        return ImdgUtil.wrapImdgFunction(MapEventJournalFunctions.mapEventToEntry());
    }

    public static <K, V> FunctionEx<EventJournalMapEvent<K, V>, V> mapEventNewValue() {
        return ImdgUtil.wrapImdgFunction(MapEventJournalFunctions.mapEventNewValue());
    }

    public static <K, V> FunctionEx<EventJournalCacheEvent<K, V>, Map.Entry<K, V>> cacheEventToEntry() {
        return ImdgUtil.wrapImdgFunction(CacheEventJournalFunctions.cacheEventToEntry());
    }

    public static <K, V> FunctionEx<EventJournalCacheEvent<K, V>, V> cacheEventNewValue() {
        return ImdgUtil.wrapImdgFunction(CacheEventJournalFunctions.cacheEventNewValue());
    }

    @Nonnull
    public static String idToString(long id) {
        char[] buf = Arrays.copyOf(ID_TEMPLATE, ID_TEMPLATE.length);
        String hexStr = Long.toHexString(id);
        int i = hexStr.length() - 1;
        int j = 18;
        while (i >= 0) {
            buf[j] = hexStr.charAt(i);
            if (j == 15 || j == 10 || j == 5) {
                --j;
            }
            --i;
            --j;
        }
        return new String(buf);
    }

    public static long idFromString(String str) {
        if (str == null || !ID_PATTERN.matcher(str).matches()) {
            return -1L;
        }
        str = StringUtil.removeCharacter(str, '-');
        return Long.parseUnsignedLong(str, 16);
    }

    public static Path getFilePathOfClasspathResource(String resourcePath) {
        ClassLoader cl = Util.class.getClassLoader();
        URL url = cl.getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Resource doesn't exist or can't be represented by a URL: " + resourcePath);
        }
        if (!Objects.equals(url.getProtocol(), "file")) {
            throw new IllegalArgumentException("Resource is not on the file system, the URL protocol is " + url.getProtocol());
        }
        return Paths.get(url.getPath(), new String[0]);
    }
}

