/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.util.ThreadAffinity;
import com.hazelcast.internal.util.ThreadAffinityHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.BitSet;

public class HazelcastManagedThread
extends Thread {
    private BitSet allowedCpus;

    public HazelcastManagedThread() {
    }

    public HazelcastManagedThread(Runnable target) {
        super(target);
    }

    public HazelcastManagedThread(String name) {
        super(name);
    }

    public HazelcastManagedThread(Runnable target, String name) {
        super(target, name);
    }

    public void setThreadAffinity(ThreadAffinity threadAffinity) {
        this.allowedCpus = threadAffinity.nextAllowedCpus();
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        if (cl != null) {
            super.setContextClassLoader(cl);
        }
    }

    protected void beforeRun() {
    }

    protected void executeRun() {
        super.run();
    }

    protected void afterRun() {
    }

    protected void beforeStart() {
    }

    @Override
    public synchronized void start() {
        this.beforeStart();
        super.start();
    }

    @Override
    public final void run() {
        if (this.allowedCpus != null) {
            ThreadAffinityHelper.setAffinity(this.allowedCpus);
            BitSet actualCpus = ThreadAffinityHelper.getAffinity();
            ILogger logger = Logger.getLogger(HazelcastManagedThread.class);
            if (!actualCpus.equals(this.allowedCpus)) {
                logger.warning(this.getName() + " affinity was not applied successfully. Expected CPUs:" + this.allowedCpus + ". Actual CPUs:" + actualCpus);
            } else {
                logger.info(this.getName() + " has affinity for CPUs:" + this.allowedCpus);
            }
        }
        try {
            this.beforeRun();
            this.executeRun();
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
        finally {
            this.afterRun();
        }
    }
}

