/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.nearcache.NearCacheStats;
import com.hazelcast.partition.LocalReplicationStats;
import com.hazelcast.query.LocalIndexStats;
import com.hazelcast.replicatedmap.LocalReplicatedMapStats;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalReplicatedMapStatsImpl
implements LocalReplicatedMapStats {
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> LAST_ACCESS_TIME = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> LAST_UPDATE_TIME = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "lastUpdateTime");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> HITS = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> NUMBER_OF_OTHER_OPERATIONS = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> NUMBER_OF_EVENTS = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "numberOfEvents");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> GET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> PUT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> REMOVE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_GET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalGetLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_PUT_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalPutLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_REMOVE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalRemoveLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_GET_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxGetLatencyNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_PUT_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxPutLatencyNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_REMOVE_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxRemoveLatencyNanos");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> OWNED_ENTRY_MEMORY_COST = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "ownedEntryMemoryCost");
    @Probe(name="lastAccessTime", unit=ProbeUnit.MS)
    private volatile long lastAccessTime;
    @Probe(name="lastUpdateTime", unit=ProbeUnit.MS)
    private volatile long lastUpdateTime;
    @Probe(name="hits")
    private volatile long hits;
    @Probe(name="numberOfOtherOperations")
    private volatile long numberOfOtherOperations;
    @Probe(name="numberOfEvents")
    private volatile long numberOfEvents;
    @Probe(name="getCount")
    private volatile long getCount;
    @Probe(name="putCount")
    private volatile long putCount;
    @Probe(name="removeCount")
    private volatile long removeCount;
    private volatile long totalGetLatenciesNanos;
    private volatile long totalPutLatenciesNanos;
    private volatile long totalRemoveLatenciesNanos;
    private volatile long maxGetLatencyNanos;
    private volatile long maxPutLatencyNanos;
    private volatile long maxRemoveLatencyNanos;
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime = Clock.currentTimeMillis();
    @Probe(name="ownedEntryCount")
    private volatile long ownedEntryCount;
    @Probe(name="ownedEntryMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long ownedEntryMemoryCost;

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return 0L;
    }

    public void setBackupEntryCount(long backupEntryCount) {
    }

    @Override
    public int getBackupCount() {
        return 0;
    }

    public void setBackupCount(int backupCount) {
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.set(this, ownedEntryMemoryCost);
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return 0L;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        ConcurrencyUtil.setMax(this, LAST_ACCESS_TIME, lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        ConcurrencyUtil.setMax(this, LAST_UPDATE_TIME, lastUpdateTime);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getEvictionCount() {
        return 0L;
    }

    @Override
    public long getExpirationCount() {
        return 0L;
    }

    public void setHits(long hits) {
        HITS.set(this, hits);
    }

    @Override
    public long getLockedEntryCount() {
        return 0L;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
    }

    @Override
    public long getDirtyEntryCount() {
        return 0L;
    }

    public void setDirtyEntryCount(long dirtyEntryCount) {
    }

    @Override
    @Probe(name="total")
    public long total() {
        return this.putCount + this.getCount + this.removeCount + this.numberOfOtherOperations;
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    public void incrementPutsNanos(long latencyNanos) {
        PUT_COUNT.incrementAndGet(this);
        TOTAL_PUT_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_PUT_LATENCY, latencyNanos);
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    public void incrementGetsNanos(long latencyNanos) {
        GET_COUNT.incrementAndGet(this);
        TOTAL_GET_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_GET_LATENCY, latencyNanos);
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    public void incrementRemovesNanos(long latencyNanos) {
        REMOVE_COUNT.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_REMOVE_LATENCY, latencyNanos);
    }

    @Override
    @Probe(name="totalPutLatencies", unit=ProbeUnit.MS)
    public long getTotalPutLatency() {
        return TimeUtil.convertNanosToMillis(this.totalPutLatenciesNanos);
    }

    @Override
    @Probe(name="totalGetLatencies", unit=ProbeUnit.MS)
    public long getTotalGetLatency() {
        return TimeUtil.convertNanosToMillis(this.totalGetLatenciesNanos);
    }

    @Override
    @Probe(name="totalRemoveLatencies", unit=ProbeUnit.MS)
    public long getTotalRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.totalRemoveLatenciesNanos);
    }

    @Override
    @Probe(name="maxPutLatency", unit=ProbeUnit.MS)
    public long getMaxPutLatency() {
        return TimeUtil.convertNanosToMillis(this.maxPutLatencyNanos);
    }

    @Override
    @Probe(name="maxGetLatency", unit=ProbeUnit.MS)
    public long getMaxGetLatency() {
        return TimeUtil.convertNanosToMillis(this.maxGetLatencyNanos);
    }

    @Override
    @Probe(name="maxRemoveLatency", unit=ProbeUnit.MS)
    public long getMaxRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.maxRemoveLatencyNanos);
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations;
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS.incrementAndGet(this);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS.incrementAndGet(this);
    }

    @Override
    public long getHeapCost() {
        return 0L;
    }

    public void setHeapCost(long heapCost) {
    }

    @Override
    public long getMerkleTreesCost() {
        return 0L;
    }

    public void setMerkleTreesCost(long merkleTreesCost) {
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        throw new UnsupportedOperationException("Replicated map has no Near Cache!");
    }

    @Override
    public long getQueryCount() {
        throw new UnsupportedOperationException("Queries on replicated maps are not supported.");
    }

    @Override
    public long getIndexedQueryCount() {
        throw new UnsupportedOperationException("Queries on replicated maps are not supported.");
    }

    @Override
    public Map<String, LocalIndexStats> getIndexStats() {
        throw new UnsupportedOperationException("Queries on replicated maps are not supported.");
    }

    @Override
    public long getSetOperationCount() {
        throw new UnsupportedOperationException("Set operation on replicated maps is not supported.");
    }

    @Override
    public long getTotalSetLatency() {
        throw new UnsupportedOperationException("Set operation on replicated maps is not supported.");
    }

    @Override
    public long getMaxSetLatency() {
        throw new UnsupportedOperationException("Set operation on replicated maps is not supported.");
    }

    @Override
    public LocalReplicationStats getReplicationStats() {
        throw new UnsupportedOperationException("Replication stats are not available for replicated maps.");
    }

    public String toString() {
        return "LocalReplicatedMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + TimeUtil.convertNanosToMillis(this.totalGetLatenciesNanos) + ", totalPutLatencies=" + TimeUtil.convertNanosToMillis(this.totalPutLatenciesNanos) + ", totalRemoveLatencies=" + TimeUtil.convertNanosToMillis(this.totalRemoveLatenciesNanos) + ", ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + "}";
    }
}

